/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.PartialBinaryTupleMatcher;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite3.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite3.internal.storage.pagememory.index.freelist.ReadIndexColumnsValue;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite3.internal.util.GridUnsafe;

public interface SortedIndexTreeIo {
    public static final int ITEM_SIZE_WITHOUT_COLUMNS = 24;
    public static final short NOT_FULLY_INLINE = -1;
    public static final int SIZE_OFFSET = 0;
    public static final int TUPLE_OFFSET = 2;

    default public int linkOffset() {
        return 2 + this.indexColumnsInlineSize();
    }

    default public int rowIdMsbOffset() {
        return this.linkOffset() + 6;
    }

    default public int rowIdLsbOffset() {
        return this.rowIdMsbOffset() + 8;
    }

    public int getItemSize();

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<SortedIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory(srcPageAddr, (long)srcOffset, dstPageAddr, (long)dstOffset, (long)this.getItemSize());
    }

    default public void storeByOffset(long pageAddr, int off, SortedIndexRowKey rowKey) {
        if (!1.$assertionsDisabled && !(rowKey instanceof SortedIndexRow)) {
            throw new AssertionError();
        }
        SortedIndexRow row = (SortedIndexRow)rowKey;
        IndexColumns indexColumns = row.indexColumns();
        if (InlineUtils.canFullyInline(indexColumns.valueSize(), this.indexColumnsInlineSize())) {
            if (!1.$assertionsDisabled && indexColumns.link() != 0L) {
                throw new AssertionError((Object)"Index columns are completely inline, they should not be in FreeList");
            }
            PageUtils.putShort(pageAddr + (long)off, 0, (short)indexColumns.valueSize());
            PageUtils.putByteBuffer(pageAddr + (long)off, 2, indexColumns.valueBuffer().rewind());
        } else {
            PageUtils.putShort(pageAddr + (long)off, 0, (short)-1);
            ByteBuffer bufferToWrite = indexColumns.valueBuffer().rewind().duplicate().limit(this.indexColumnsInlineSize());
            PageUtils.putByteBuffer(pageAddr + (long)off, 2, bufferToWrite);
            PartitionlessLinks.writePartitionless(pageAddr + (long)off + (long)this.linkOffset(), indexColumns.link());
        }
        RowId rowId = row.rowId();
        PageUtils.putLong(pageAddr + (long)off, this.rowIdMsbOffset(), rowId.mostSignificantBits());
        PageUtils.putLong(pageAddr + (long)off, this.rowIdLsbOffset(), rowId.leastSignificantBits());
    }

    default public int compare(DataPageReader dataPageReader, Comparator<ByteBuffer> binaryTupleComparator, PartialBinaryTupleMatcher partialBinaryTupleComparator, int partitionId, long pageAddr, int idx, SortedIndexRowKey rowKey) throws IgniteInternalCheckedException {
        ByteBuffer firstBinaryTupleBuffer;
        int off = this.offset(idx);
        short indexColumnsSize = PageUtils.getShort(pageAddr + (long)off, 0);
        ByteBuffer secondBinaryTupleBuffer = rowKey.indexColumns().valueBuffer();
        if (indexColumnsSize == -1) {
            ByteBuffer partialFirstBinaryTupleBuffer = GridUnsafe.wrapPointer(pageAddr + (long)off + 2L, this.indexColumnsInlineSize());
            int firstCmp = partialBinaryTupleComparator.match(partialFirstBinaryTupleBuffer.order(ByteOrder.LITTLE_ENDIAN), secondBinaryTupleBuffer);
            if (firstCmp != 0) {
                return firstCmp;
            }
            long link = PartitionlessLinks.readPartitionless(partitionId, pageAddr + (long)off, this.linkOffset());
            ReadIndexColumnsValue indexColumnsTraversal = new ReadIndexColumnsValue();
            dataPageReader.traverse(link, indexColumnsTraversal, null);
            firstBinaryTupleBuffer = ByteBuffer.wrap(indexColumnsTraversal.result());
        } else {
            firstBinaryTupleBuffer = GridUnsafe.wrapPointer(pageAddr + (long)off + 2L, indexColumnsSize);
        }
        int cmp = binaryTupleComparator.compare(firstBinaryTupleBuffer.order(ByteOrder.LITTLE_ENDIAN), secondBinaryTupleBuffer);
        if (cmp != 0) {
            return cmp;
        }
        if (!1.$assertionsDisabled && !(rowKey instanceof SortedIndexRow)) {
            throw new AssertionError(rowKey);
        }
        SortedIndexRow row = (SortedIndexRow)rowKey;
        long rowIdMsb = PageUtils.getLong(pageAddr + (long)off, this.rowIdMsbOffset());
        cmp = Long.compare(rowIdMsb, row.rowId().mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        long rowIdLsb = PageUtils.getLong(pageAddr + (long)off, this.rowIdLsbOffset());
        return Long.compare(rowIdLsb, row.rowId().leastSignificantBits());
    }

    default public SortedIndexRow getRow(DataPageReader dataPageReader, int partitionId, long pageAddr, int idx) throws IgniteInternalCheckedException {
        ByteBuffer indexColumnsBuffer;
        long link;
        int off = this.offset(idx);
        short indexColumnsSize = PageUtils.getShort(pageAddr + (long)off, 0);
        if (indexColumnsSize == -1) {
            link = PartitionlessLinks.readPartitionless(partitionId, pageAddr + (long)off, this.linkOffset());
            ReadIndexColumnsValue indexColumnsTraversal = new ReadIndexColumnsValue();
            dataPageReader.traverse(link, indexColumnsTraversal, null);
            indexColumnsBuffer = ByteBuffer.wrap(indexColumnsTraversal.result());
        } else {
            indexColumnsBuffer = ByteBuffer.wrap(PageUtils.getBytes(pageAddr + (long)off, 2, indexColumnsSize));
            link = 0L;
        }
        IndexColumns indexColumns = new IndexColumns(partitionId, link, indexColumnsBuffer.order(ByteOrder.LITTLE_ENDIAN));
        long rowIdMsb = PageUtils.getLong(pageAddr + (long)off, this.rowIdMsbOffset());
        long rowIdLsb = PageUtils.getLong(pageAddr + (long)off, this.rowIdLsbOffset());
        RowId rowId = new RowId(partitionId, rowIdMsb, rowIdLsb);
        return new SortedIndexRow(indexColumns, rowId);
    }

    default public int indexColumnsInlineSize() {
        return this.getItemSize() - 24;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

