/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.prepare.Fragment;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadata;
import org.jetbrains.annotations.Nullable;

public class MappedFragment {
    private final Fragment fragment;
    private final List<ColocationGroup> groups;
    private final List<String> nodes;
    private final Long2ObjectMap<ColocationGroup> groupsBySourceId;
    @Nullable
    private final Long2ObjectMap<List<String>> sourcesByExchangeId;
    @Nullable
    private final ColocationGroup target;
    private final PartitionPruningMetadata partitionPruningMetadata;

    MappedFragment(Fragment fragment, List<ColocationGroup> groups, @Nullable Long2ObjectMap<List<String>> sourcesByExchangeId, @Nullable ColocationGroup target, @Nullable PartitionPruningMetadata pruningMetadata) {
        this.fragment = fragment;
        this.groups = groups;
        HashSet<String> nodes = new HashSet<String>();
        Long2ObjectOpenHashMap groupsBySourceId = new Long2ObjectOpenHashMap();
        for (ColocationGroup group : groups) {
            nodes.addAll(group.nodeNames());
            LongListIterator longListIterator = group.sourceIds().iterator();
            while (longListIterator.hasNext()) {
                long sourceId = (Long)longListIterator.next();
                groupsBySourceId.put(sourceId, (Object)group);
            }
        }
        this.nodes = List.copyOf(nodes);
        this.groupsBySourceId = groupsBySourceId;
        this.sourcesByExchangeId = sourcesByExchangeId;
        this.target = target;
        this.partitionPruningMetadata = pruningMetadata;
    }

    private MappedFragment(Fragment fragment, List<ColocationGroup> groups, List<String> nodes, Long2ObjectMap<ColocationGroup> groupsBySourceId, @Nullable Long2ObjectMap<List<String>> sourcesByExchangeId, @Nullable ColocationGroup target, @Nullable PartitionPruningMetadata pruningMetadata) {
        this.fragment = fragment;
        this.nodes = List.copyOf(nodes);
        this.groupsBySourceId = groupsBySourceId;
        this.sourcesByExchangeId = sourcesByExchangeId;
        this.target = target;
        this.groups = groups;
        this.partitionPruningMetadata = pruningMetadata;
    }

    public Fragment fragment() {
        return this.fragment;
    }

    public List<ColocationGroup> groups() {
        return this.groups;
    }

    public List<String> nodes() {
        return this.nodes;
    }

    public Long2ObjectMap<ColocationGroup> groupsBySourceId() {
        return this.groupsBySourceId;
    }

    @Nullable
    public ColocationGroup target() {
        return this.target;
    }

    @Nullable
    public Long2ObjectMap<List<String>> sourcesByExchangeId() {
        return this.sourcesByExchangeId;
    }

    @Nullable
    public PartitionPruningMetadata partitionPruningMetadata() {
        return this.partitionPruningMetadata;
    }

    public MappedFragment replaceColocationGroups(Long2ObjectMap<ColocationGroup> replacedGroups) {
        ArrayList<ColocationGroup> newGroups = new ArrayList<ColocationGroup>(this.groupsBySourceId.size());
        for (Long2ObjectMap.Entry e : this.groupsBySourceId.long2ObjectEntrySet()) {
            ColocationGroup newGroup = (ColocationGroup)replacedGroups.get(e.getLongKey());
            if (newGroup != null) {
                newGroups.add(newGroup);
                continue;
            }
            ColocationGroup existing = (ColocationGroup)e.getValue();
            existing = existing.removeSources(replacedGroups.keySet());
            assert (!existing.sourceIds().isEmpty()) : "ColocationGroup has no sources. Source id: " + e.getLongKey() + " node names: " + existing.nodeNames() + " assignments: " + existing.assignments() + " replaced groups: " + replacedGroups.keySet();
            newGroups.add(existing);
        }
        return new MappedFragment(this.fragment, newGroups, this.sourcesByExchangeId, this.target, this.partitionPruningMetadata);
    }

    public MappedFragment replaceExchangeSources(long exchangeId, List<String> newNodes) {
        assert (this.sourcesByExchangeId != null) : "No sourcesByExchangeId";
        assert (!newNodes.isEmpty()) : "New nodes are empty for exchange#" + exchangeId;
        Long2ObjectArrayMap newSourcesByExchangeId = new Long2ObjectArrayMap(this.sourcesByExchangeId);
        newSourcesByExchangeId.put(exchangeId, newNodes);
        return new MappedFragment(this.fragment, this.groups, this.nodes, this.groupsBySourceId, (Long2ObjectMap<List<String>>)newSourcesByExchangeId, this.target, this.partitionPruningMetadata);
    }

    public MappedFragment withPartitionPruningMetadata(PartitionPruningMetadata pruningMetadata) {
        return new MappedFragment(this.fragment, this.groups, this.sourcesByExchangeId, this.target, pruningMetadata);
    }
}

