/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.lang.InternalTuple;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.jetbrains.annotations.Nullable;

public interface RowHandler<RowT> {
    @Nullable
    public Object get(int var1, RowT var2);

    public boolean isNull(int var1, RowT var2);

    public int columnCount(RowT var1);

    public BinaryTuple toBinaryTuple(RowT var1);

    default public ByteBuffer toByteBuffer(RowT row) {
        return this.toBinaryTuple(row).byteBuffer();
    }

    public String toString(RowT var1);

    public RowFactory<RowT> factory(RowSchema var1);

    public static interface RowBuilder<RowT> {
        public RowBuilder<RowT> addField(@Nullable Object var1);

        public RowT build();

        public void reset();

        default public RowT buildAndReset() {
            RowT row = this.build();
            this.reset();
            return row;
        }
    }

    public static interface RowFactory<RowT> {
        public RowHandler<RowT> handler();

        public RowBuilder<RowT> rowBuilder();

        public RowT create();

        public RowT create(Object ... var1);

        public RowT create(InternalTuple var1);

        public RowSchema rowSchema();

        public RowT map(RowT var1, int[] var2);
    }
}

