/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.marshaller.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.TryCatch;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.processing.Generated;
import jdk.jfr.Experimental;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.marshaller.BinaryMode;
import org.apache.ignite3.internal.marshaller.MarshallerColumn;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite3.internal.schema.marshaller.MarshallerFactory;
import org.apache.ignite3.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite3.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite3.internal.schema.marshaller.asm.ColumnAccessCodeGenerator;
import org.apache.ignite3.internal.schema.marshaller.asm.IdentityMarshallerCodeGenerator;
import org.apache.ignite3.internal.schema.marshaller.asm.MarshallerCodeGenerator;
import org.apache.ignite3.internal.schema.marshaller.asm.ObjectMarshallerCodeGenerator;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.schema.row.RowAssembler;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.util.ObjectFactory;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.PojoMapper;

@Experimental
public class AsmMarshallerGenerator
implements MarshallerFactory {
    private static final IgniteLogger LOG = Loggers.forClass(AsmMarshallerGenerator.class);
    public static final String MARSHALLER_PACKAGE_NAME = "org.apache.ignite3.internal.schema.marshaller";
    public static final String MARSHALLER_CLASS_NAME_PREFIX = "MarshallerForSchema_";
    private final boolean dumpCode = LOG.isTraceEnabled();

    @Override
    public <K, V> KvMarshaller<K, V> create(SchemaDescriptor schema, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        String className = MARSHALLER_CLASS_NAME_PREFIX + schema.version();
        Class<K> keyClass = keyMapper.targetType();
        Class<V> valClass = valueMapper.targetType();
        StringWriter writer = new StringWriter();
        try {
            long generation = System.nanoTime();
            ClassDefinition classDef = this.generateMarshallerClass(className, schema, keyMapper, valueMapper);
            long compilationTime = System.nanoTime();
            generation = compilationTime - generation;
            ClassGenerator generator = ClassGenerator.classGenerator(AsmMarshallerGenerator.getClassLoader());
            if (this.dumpCode) {
                generator = generator.outputTo(writer).fakeLineNumbers(true).runAsmVerifier(true).dumpRawBytecode(true);
            }
            Class<KvMarshaller> aClass = generator.defineClass(classDef, KvMarshaller.class);
            compilationTime = System.nanoTime() - compilationTime;
            if (LOG.isTraceEnabled()) {
                LOG.trace("ASM marshaller created: codeGenStage={}us, compileStage={}us. Code: {}", TimeUnit.NANOSECONDS.toMicros(generation), TimeUnit.NANOSECONDS.toMicros(compilationTime), writer);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ASM marshaller created: codeGenStage={}us, compileStage={}us.", TimeUnit.NANOSECONDS.toMicros(generation), TimeUnit.NANOSECONDS.toMicros(compilationTime));
            }
            return aClass.getDeclaredConstructor(SchemaDescriptor.class, ObjectFactory.class, ObjectFactory.class).newInstance(schema, MarshallerUtil.factoryForClass(keyClass), MarshallerUtil.factoryForClass(valClass));
        }
        catch (IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshallerException("Failed to create marshaller for key-value pair: schemaVer=" + schema.version() + ", keyClass=" + keyClass.getSimpleName() + ", valueClass=" + valClass.getSimpleName(), e);
        }
    }

    @Override
    public <R> RecordMarshaller<R> create(SchemaDescriptor schema, Mapper<R> mapper) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private ClassDefinition generateMarshallerClass(String className, SchemaDescriptor schema, Mapper<?> keyMapper, Mapper<?> valMapper) {
        MarshallerCodeGenerator keyMarsh = AsmMarshallerGenerator.createMarshaller(keyMapper, schema.keyColumns(), 0);
        MarshallerCodeGenerator valMarsh = AsmMarshallerGenerator.createMarshaller(valMapper, schema.valueColumns(), schema.keyColumns().size());
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC), MARSHALLER_PACKAGE_NAME.replace('.', '/') + "/" + className, ParameterizedType.type(Object.class), ParameterizedType.type(KvMarshaller.class));
        classDef.declareAnnotation(Generated.class).setValue("value", this.getClass().getCanonicalName());
        keyMarsh.initStaticHandlers(classDef);
        valMarsh.initStaticHandlers(classDef);
        this.generateFieldsAndConstructor(classDef);
        this.generateAssemblerFactoryMethod(classDef, schema, keyMarsh, valMarsh);
        this.generateSchemaVersionMethod(classDef, schema);
        this.generateMarshalMethod(classDef, keyMarsh, valMarsh);
        this.generateUnmarshalKeyMethod(classDef, keyMarsh);
        this.generateUnmarshalValueMethod(classDef, valMarsh);
        return classDef;
    }

    private void generateSchemaVersionMethod(ClassDefinition classDef, SchemaDescriptor schema) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaVersion", ParameterizedType.type(Integer.TYPE), new Parameter[0]);
        methodDef.declareAnnotation(Override.class);
        methodDef.getBody().push(schema.version()).retInt();
    }

    private static MarshallerCodeGenerator createMarshaller(Mapper<?> mapper, List<Column> columns, int firstColIdx) {
        BinaryMode mode = BinaryMode.forClass(mapper.targetType());
        if (mode == BinaryMode.POJO) {
            MarshallerColumn[] marshallerColumns = MarshallerUtil.toMarshallerColumns(columns);
            return new ObjectMarshallerCodeGenerator(marshallerColumns, (PojoMapper)mapper, firstColIdx);
        }
        return new IdentityMarshallerCodeGenerator(ColumnAccessCodeGenerator.createAccessor(mode, null, firstColIdx));
    }

    private void generateFieldsAndConstructor(ClassDefinition classDef) {
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "keyFactory", ParameterizedType.type(ObjectFactory.class));
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "valFactory", ParameterizedType.type(ObjectFactory.class));
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "schema", ParameterizedType.type(SchemaDescriptor.class));
        MethodDefinition constrDef = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), Parameter.arg("schema", SchemaDescriptor.class), Parameter.arg("keyFactory", ParameterizedType.type(ObjectFactory.class)), Parameter.arg("valFactory", ParameterizedType.type(ObjectFactory.class)));
        constrDef.getBody().append(constrDef.getThis()).invokeConstructor(classDef.getSuperClass(), new ParameterizedType[0]).append(constrDef.getThis().setField("schema", (BytecodeExpression)constrDef.getScope().getVariable("schema"))).append(constrDef.getThis().setField("keyFactory", (BytecodeExpression)constrDef.getScope().getVariable("keyFactory"))).append(constrDef.getThis().setField("valFactory", (BytecodeExpression)constrDef.getScope().getVariable("valFactory"))).ret();
    }

    private void generateAssemblerFactoryMethod(ClassDefinition classDef, SchemaDescriptor schema, MarshallerCodeGenerator keyMarsh, MarshallerCodeGenerator valMarsh) {
        BytecodeExpression valueSize;
        NativeType type;
        int i;
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PRIVATE), "createAssembler", ParameterizedType.type(RowAssembler.class), Parameter.arg("key", Object.class), Parameter.arg("val", Object.class));
        Scope scope = methodDef.getScope();
        BytecodeBlock body = methodDef.getBody();
        Variable estimatedValueSize = scope.declareVariable("estimatedValueSize", body, BytecodeExpressions.defaultValue(Integer.TYPE));
        BytecodeExpression schemaField = methodDef.getThis().getField("schema", SchemaDescriptor.class);
        Variable keyCols = scope.declareVariable("keyCols", body, schemaField.invoke("keyColumns", ParameterizedType.type(List.class, Column.class), List.of()));
        Variable valCols = scope.declareVariable("valCols", body, schemaField.invoke("valueColumns", ParameterizedType.type(List.class, Column.class), List.of()));
        List<Column> columns = schema.keyColumns();
        Variable value = scope.createTempVariable(Object.class);
        boolean exactSizeEstimate = true;
        for (i = 0; i < columns.size(); ++i) {
            body.append(keyMarsh.getValue(classDef.getType(), scope.getVariable("key"), i)).putVariable(value);
            type = columns.get(i).type();
            valueSize = type.fixedLength() ? BytecodeExpressions.constantInt(type.sizeInBytes()) : AsmMarshallerGenerator.getValueSize(value, AsmMarshallerGenerator.getColumnType(keyCols, i));
            exactSizeEstimate = exactSizeEstimate && type.fixedLength();
            body.append(new IfStatement().condition(BytecodeExpressions.isNull(value)).ifFalse(AsmMarshallerGenerator.plusEquals(estimatedValueSize, valueSize)));
        }
        columns = schema.valueColumns();
        for (i = 0; i < columns.size(); ++i) {
            body.append(valMarsh.getValue(classDef.getType(), scope.getVariable("val"), i)).putVariable(value);
            type = columns.get(i).type();
            valueSize = type.fixedLength() ? BytecodeExpressions.constantInt(type.sizeInBytes()) : AsmMarshallerGenerator.getValueSize(value, AsmMarshallerGenerator.getColumnType(valCols, i));
            exactSizeEstimate = exactSizeEstimate && type.fixedLength();
            body.append(new IfStatement().condition(BytecodeExpressions.isNull(value)).ifFalse(AsmMarshallerGenerator.plusEquals(estimatedValueSize, valueSize)));
        }
        body.append(BytecodeExpressions.newInstance(RowAssembler.class, schemaField, estimatedValueSize, BytecodeExpressions.constantBoolean(exactSizeEstimate)));
        body.retObject();
    }

    private static BytecodeExpression getValueSize(Variable val, BytecodeExpression type) {
        return BytecodeExpressions.invokeStatic(MarshallerUtil.class, "getValueSize", Integer.TYPE, val, type);
    }

    private static BytecodeExpression getColumnType(Variable columns, int i) {
        return columns.invoke("get", Object.class, BytecodeExpressions.constantInt(i)).cast(Column.class).invoke("type", NativeType.class, new BytecodeExpression[0]);
    }

    private static BytecodeExpression plusEquals(Variable var, BytecodeExpression expression) {
        return var.set(BytecodeExpressions.add(var, expression));
    }

    private void generateMarshalMethod(ClassDefinition classDef, MarshallerCodeGenerator keyMarsh, MarshallerCodeGenerator valMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "marshal", ParameterizedType.type(Row.class), Parameter.arg("key", Object.class), Parameter.arg("val", Object.class)).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable asm = methodDef.getScope().createTempVariable(RowAssembler.class);
        methodDef.getBody().append(asm.set(methodDef.getScope().getThis().invoke("createAssembler", RowAssembler.class, methodDef.getScope().getVariable("key"), methodDef.getScope().getVariable("val")))).append(new IfStatement().condition(BytecodeExpressions.isNull(asm)).ifTrue(new BytecodeBlock().append(BytecodeExpressions.newInstance(IgniteInternalException.class, BytecodeExpressions.constantString("ASM can't be null."))).throwObject()));
        BytecodeBlock block = new BytecodeBlock();
        block.append(keyMarsh.marshallObject(classDef.getType(), asm, methodDef.getScope().getVariable("key"))).append(valMarsh.marshallObject(classDef.getType(), asm, methodDef.getScope().getVariable("val"))).append(BytecodeExpressions.invokeStatic(Row.class, "wrapBinaryRow", Row.class, methodDef.getThis().getField("schema", SchemaDescriptor.class), asm.invoke("build", BinaryRow.class, new BytecodeExpression[0]))).retObject();
        Variable ex = methodDef.getScope().createTempVariable(Throwable.class);
        BytecodeExpression message = ex.invoke("getMessage", String.class, new BytecodeExpression[0]);
        methodDef.getBody().append(new TryCatch(block, new BytecodeBlock().putVariable(ex).append(BytecodeExpressions.newInstance(MarshallerException.class, message, ex)).throwObject(), ParameterizedType.type(Throwable.class)));
    }

    private void generateUnmarshalKeyMethod(ClassDefinition classDef, MarshallerCodeGenerator keyMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "unmarshalKey", ParameterizedType.type(Object.class), Parameter.arg("row", Row.class)).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable objVar = methodDef.getScope().declareVariable(Object.class, "obj");
        Variable objFactory = methodDef.getScope().declareVariable("factory", methodDef.getBody(), methodDef.getThis().getField("keyFactory", ObjectFactory.class));
        methodDef.getBody().append(keyMarsh.unmarshallObject(classDef.getType(), methodDef.getScope().getVariable("row"), objVar, objFactory)).append(objVar).retObject();
    }

    private void generateUnmarshalValueMethod(ClassDefinition classDef, MarshallerCodeGenerator valMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "unmarshalValue", ParameterizedType.type(Object.class), Parameter.arg("row", Row.class)).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable obj = methodDef.getScope().declareVariable(Object.class, "obj");
        Variable objFactory = methodDef.getScope().declareVariable("factory", methodDef.getBody(), methodDef.getThis().getField("valFactory", ObjectFactory.class));
        methodDef.getBody().append(valMarsh.unmarshallObject(classDef.getType(), methodDef.getScope().getVariable("row"), obj, objFactory)).append(obj).retObject();
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader() == null ? ClassLoader.getSystemClassLoader() : Thread.currentThread().getContextClassLoader();
    }
}

