/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.completer.filter;

import java.util.Arrays;
import java.util.Set;
import org.apache.ignite3.internal.cli.commands.Options;
import org.apache.ignite3.internal.cli.commands.cluster.unit.NodesAlias;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.CompleterFilter;
import org.apache.ignite3.internal.cli.util.ArrayUtils;

public class DeployUnitsOptionsFilter
implements CompleterFilter {
    private final String[] activationWords = new String[]{"cluster", "unit", "deploy"};
    private final Set<String> options = Options.UNIT_NODES.names();

    @Override
    public String[] filter(String[] words, String[] candidates) {
        int cursor;
        if (!ArrayUtils.firstStartsWithSecond(words, this.activationWords)) {
            return candidates;
        }
        boolean isActivationWordFound = false;
        for (cursor = 0; cursor < words.length; ++cursor) {
            if (!this.options.contains(words[cursor])) continue;
            isActivationWordFound = true;
            break;
        }
        if (isActivationWordFound) {
            ++cursor;
            boolean aliasFound = false;
            while (cursor < words.length && !words[cursor].startsWith("-")) {
                NodesAlias alias = NodesAlias.parse(words[cursor]);
                if (alias != null) {
                    aliasFound = true;
                    break;
                }
                ++cursor;
            }
            if (aliasFound) {
                return (String[])Arrays.stream(candidates).filter(it -> !this.options.contains(it)).toArray(String[]::new);
            }
        }
        return candidates;
    }
}

