/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.cluster.metric;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.cluster.metric.ClusterMetricSourceListCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.ClusterMetricSourceListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Lists cluster metric sources"})
public class ClusterMetricSourceListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private ClusterMetricSourceListCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list metric sources")).print(new ClusterMetricSourceListDecorator(this.plain)));
    }
}

