/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import org.apache.ignite.binary.BinaryObjectException;

final class MetadataUpdateResult {
    private final ResultType resType;
    private final BinaryObjectException error;
    private final int typeVer;

    private MetadataUpdateResult(ResultType resType, BinaryObjectException error, int typeVer) {
        this.resType = resType;
        this.error = error;
        this.typeVer = typeVer;
    }

    boolean rejected() {
        return this.resType == ResultType.REJECT;
    }

    BinaryObjectException error() {
        return this.error;
    }

    int typeVersion() {
        return this.typeVer;
    }

    static MetadataUpdateResult createSuccessfulResult(int typeVer) {
        return new MetadataUpdateResult(ResultType.SUCCESS, null, typeVer);
    }

    static MetadataUpdateResult createFailureResult(BinaryObjectException err) {
        assert (err != null);
        return new MetadataUpdateResult(ResultType.REJECT, err, -1);
    }

    static MetadataUpdateResult createUpdateDisabledResult() {
        return new MetadataUpdateResult(ResultType.UPDATE_DISABLED, null, -1);
    }

    private static enum ResultType {
        SUCCESS,
        REJECT,
        UPDATE_DISABLED;

    }
}

