/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tracing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.tracing.TracingConfigurationCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetAllCommandArg;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetCommandArg;
import org.apache.ignite.internal.management.tracing.TracingConfigurationSetCommandArg;
import org.apache.ignite.internal.management.tracing.TracingConfigurationTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class TracingConfigurationTask
extends VisorOneNodeTask<TracingConfigurationCommand.TracingConfigurationCommandArg, TracingConfigurationTaskResult> {
    private static final long serialVersionUID = 0L;

    protected TracingConfigurationJob job(TracingConfigurationCommand.TracingConfigurationCommandArg arg) {
        return new TracingConfigurationJob(arg, this.debug);
    }

    private static class TracingConfigurationJob
    extends VisorJob<TracingConfigurationCommand.TracingConfigurationCommandArg, TracingConfigurationTaskResult> {
        private static final long serialVersionUID = 0L;

        private TracingConfigurationJob(TracingConfigurationCommand.TracingConfigurationCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        @NotNull
        protected TracingConfigurationTaskResult run(TracingConfigurationCommand.TracingConfigurationCommandArg arg) throws IgniteException {
            if (arg instanceof TracingConfigurationCommand.TracingConfigurationResetAllCommandArg) {
                return this.resetAll(((TracingConfigurationCommand.TracingConfigurationResetAllCommandArg)arg).scope());
            }
            if (arg instanceof TracingConfigurationCommand.TracingConfigurationResetCommandArg) {
                TracingConfigurationCommand.TracingConfigurationResetCommandArg arg0 = (TracingConfigurationCommand.TracingConfigurationResetCommandArg)arg;
                return this.reset(arg0.scope(), arg0.label());
            }
            if (arg instanceof TracingConfigurationSetCommandArg) {
                TracingConfigurationSetCommandArg arg0 = (TracingConfigurationSetCommandArg)arg;
                HashSet<Scope> includedScopes = arg0.includedScopes() == null ? null : new HashSet<Scope>(Arrays.asList(arg0.includedScopes()));
                return this.set(arg0.scope(), arg0.label(), arg0.samplingRate(), includedScopes);
            }
            if (arg instanceof TracingConfigurationGetAllCommandArg) {
                return this.getAll(((TracingConfigurationGetAllCommandArg)arg).scope());
            }
            if (arg instanceof TracingConfigurationGetCommandArg) {
                TracingConfigurationGetCommandArg arg0 = (TracingConfigurationGetCommandArg)arg;
                return this.get(arg0.scope(), arg0.label());
            }
            assert (false) : "Unexpected tracing configuration argument [arg= " + arg + "]";
            return this.getAll(null);
        }

        @NotNull
        private TracingConfigurationTaskResult getAll(@Nullable Scope scope) {
            Map<TracingConfigurationCoordinates, TracingConfigurationParameters> cfg = this.ignite.tracingConfiguration().getAll(scope);
            TracingConfigurationTaskResult res = new TracingConfigurationTaskResult();
            for (Map.Entry<TracingConfigurationCoordinates, TracingConfigurationParameters> entry : cfg.entrySet()) {
                res.add(entry.getKey(), entry.getValue());
            }
            return res;
        }

        @NotNull
        private TracingConfigurationTaskResult get(@NotNull Scope scope, @Nullable String lb) {
            TracingConfigurationCoordinates coordinates = new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build();
            TracingConfigurationParameters updatedParameters = this.ignite.tracingConfiguration().get(new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build());
            TracingConfigurationTaskResult res = new TracingConfigurationTaskResult();
            res.add(coordinates, updatedParameters);
            return res;
        }

        @NotNull
        private TracingConfigurationTaskResult reset(@NotNull Scope scope, @Nullable String lb) {
            this.ignite.tracingConfiguration().reset(new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build());
            return this.getAll(scope);
        }

        @NotNull
        private TracingConfigurationTaskResult resetAll(@Nullable Scope scope) {
            this.ignite.tracingConfiguration().resetAll(scope);
            return this.getAll(scope);
        }

        @NotNull
        private TracingConfigurationTaskResult set(@NotNull Scope scope, @Nullable String lb, @Nullable Double samplingRate, @Nullable Set<Scope> includedScopes) {
            TracingConfigurationCoordinates coordinates = new TracingConfigurationCoordinates.Builder(scope).withLabel(lb).build();
            TracingConfigurationParameters.Builder parametersBuilder = new TracingConfigurationParameters.Builder();
            if (samplingRate != null) {
                parametersBuilder.withSamplingRate(samplingRate);
            }
            if (includedScopes != null) {
                parametersBuilder.withIncludedScopes(includedScopes);
            }
            this.ignite.tracingConfiguration().set(coordinates, parametersBuilder.build());
            return this.getAll(scope);
        }

        public String toString() {
            return S.toString(TracingConfigurationJob.class, this);
        }
    }
}

