/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class AssignmentsLink {
    private final Assignments assignments;
    private final long configurationIndex;
    private final long configurationTerm;
    @Nullable
    private AssignmentsLink next;

    AssignmentsLink(Assignments assignments, long configurationTerm, long configurationIndex) {
        this.assignments = assignments;
        this.configurationIndex = configurationIndex;
        this.configurationTerm = configurationTerm;
    }

    public Assignments assignments() {
        return this.assignments;
    }

    @Nullable
    public AssignmentsLink next() {
        return this.next;
    }

    void next(@Nullable AssignmentsLink next) {
        this.next = next;
    }

    public boolean hasNode(String nodeConsistentId) {
        return this.assignments.nodes().stream().map(Assignment::consistentId).anyMatch(consistentId -> consistentId.equals(nodeConsistentId));
    }

    public Set<String> nodeNames() {
        return this.assignments.nodes().stream().map(Assignment::consistentId).collect(Collectors.toSet());
    }

    public long configurationIndex() {
        return this.configurationIndex;
    }

    public long configurationTerm() {
        return this.configurationTerm;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentsLink other = (AssignmentsLink)o;
        return this.configurationIndex == other.configurationIndex && this.configurationTerm == other.configurationTerm && Objects.equals(this.assignments, other.assignments) && this.assignments.timestamp() == other.assignments.timestamp();
    }

    public int hashCode() {
        int result = Objects.hashCode(this.assignments);
        result = 31 * result + Long.hashCode(this.configurationIndex);
        result = 31 * result + Long.hashCode(this.configurationTerm);
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

