/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util.format;

import java.util.Objects;
import org.apache.ignite.internal.sql.engine.util.format.DateTimeTemplateField;

final class DateTimeFormatElement {
    final ElementKind kind;
    final char delimiter;
    final DateTimeTemplateField template;

    DateTimeFormatElement(char c) {
        this.kind = ElementKind.DELIMITER;
        this.delimiter = c;
        this.template = null;
    }

    DateTimeFormatElement(DateTimeTemplateField template) {
        this.kind = ElementKind.FIELD;
        this.delimiter = '\u0000';
        this.template = template;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTimeFormatElement)) {
            return false;
        }
        DateTimeFormatElement element = (DateTimeFormatElement)o;
        return this.delimiter == element.delimiter && this.kind == element.kind && this.template == element.template;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, Character.valueOf(this.delimiter), this.template});
    }

    public String toString() {
        switch (this.kind.ordinal()) {
            case 0: {
                return "delimiter <" + this.delimiter + ">";
            }
            case 1: {
                return "field " + this.template.name();
            }
        }
        throw new IllegalStateException();
    }

    static enum ElementKind {
        DELIMITER,
        FIELD;

    }
}

