/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import java.util.regex.Pattern;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.CamelCaseKeys;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;

public class CamelCaseKeysValidator
implements Validator<CamelCaseKeys, NamedListView<?>> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("^[a-z]+([A-Z][a-z]+)*$");

    public void validate(CamelCaseKeys annotation, ValidationContext<NamedListView<?>> ctx) {
        for (String namedListKey : ((NamedListView)ctx.getNewValue()).namedListKeys()) {
            if (CAMEL_CASE_PATTERN.matcher(namedListKey).matches()) continue;
            String message = String.format("'%s' configuration key must be in lower camel case '%s', for example 'v', 'value' and 'valueOneAndTwo'", ctx.currentKey(), namedListKey);
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }
}

