/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.DisposalCallback;

@Internal
final class OffLockDisposalCallback<T extends ModalCloseable>
implements DisposalCallback<T> {
    private final DisposalCallback<T> delegate;
    private final Queue<T> gracefulQueue = new ConcurrentLinkedQueue<T>();

    OffLockDisposalCallback(DisposalCallback<T> delegate) {
        this.delegate = delegate;
    }

    public void execute(T closeable, CloseMode mode) {
        if (mode == CloseMode.IMMEDIATE) {
            this.delegate.execute(closeable, CloseMode.IMMEDIATE);
        } else {
            this.gracefulQueue.offer(closeable);
        }
    }

    void drain() {
        ModalCloseable c;
        while ((c = (ModalCloseable)this.gracefulQueue.poll()) != null) {
            this.delegate.execute(c, CloseMode.GRACEFUL);
        }
    }
}

