/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDerivationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDerivationInterceptor.class);
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());
    private static final String NAME = "keyDerivationService";
    private AttributeType krb5KeyAT;
    private AttributeType krb5PrincipalNameAT;
    private AttributeType krb5KeyVersionNumberAT;
    private AttributeType userPasswordAT;

    public KeyDerivationInterceptor() {
        super(NAME);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.krb5KeyAT = this.schemaManager.lookupAttributeTypeRegistry("krb5Key");
        this.krb5PrincipalNameAT = this.schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName");
        this.krb5KeyVersionNumberAT = this.schemaManager.lookupAttributeTypeRegistry("krb5KeyVersionNumber");
        this.userPasswordAT = this.schemaManager.lookupAttributeTypeRegistry("userPassword");
        LOG_KRB.info("KeyDerivation Interceptor initialized");
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (addContext.isReplEvent()) {
            this.next(addContext);
            return;
        }
        Dn normName = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (entry.get(this.userPasswordAT) != null && entry.get(this.krb5PrincipalNameAT) != null) {
            LOG.debug("Adding the entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
            Value userPassword = entry.get(this.userPasswordAT).get();
            String strUserPassword = Strings.utf8ToString(userPassword.getBytes());
            String principalName = entry.get(this.krb5PrincipalNameAT).getString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got principal '{}'.", (Object)principalName);
            }
            if (LOG_KRB.isDebugEnabled()) {
                LOG_KRB.debug("Got principal '{}'", (Object)principalName);
            }
            Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, strUserPassword);
            entry.put(this.krb5KeyVersionNumberAT, "0");
            Attribute keyAttribute = this.getKeyAttribute(keys);
            entry.put(keyAttribute);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding modified entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
            }
            if (LOG_KRB.isDebugEnabled()) {
                LOG_KRB.debug("Adding modified entry '{}' for Dn '{}'.", (Object)entry, (Object)normName.getName());
            }
        }
        this.next(addContext);
    }

    @Override
    public void modify(ModifyOperationContext modContext) throws LdapException {
        if (modContext.isReplEvent()) {
            this.next(modContext);
            return;
        }
        ModifySubContext subContext = new ModifySubContext();
        this.detectPasswordModification(modContext, subContext);
        if (subContext.getUserPassword() != null) {
            this.lookupPrincipalAttributes(modContext, subContext);
        }
        if (subContext.isPrincipal() && subContext.hasValues()) {
            this.deriveKeys(modContext, subContext);
        }
        this.next(modContext);
    }

    private void detectPasswordModification(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List<Modification> mods = modContext.getModItems();
        String operation = null;
        for (Modification mod : mods) {
            Attribute attr;
            if (LOG.isDebugEnabled()) {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        operation = "Adding";
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        operation = "Removing";
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        operation = "Replacing";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected modify operation " + (Object)((Object)mod.getOperation()));
                    }
                }
            }
            if (this.userPasswordAT.equals((attr = mod.getAttribute()).getAttributeType())) {
                Value firstValue = attr.get();
                String password = null;
                if (firstValue.isHumanReadable()) {
                    password = firstValue.getString();
                    LOG.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                    LOG_KRB.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)password);
                } else {
                    password = Strings.utf8ToString(firstValue.getBytes());
                }
                subContext.setUserPassword(password);
            }
            if (!this.krb5PrincipalNameAT.equals(attr.getAttributeType())) continue;
            subContext.setPrincipalName(attr.getString());
            LOG.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
            LOG_KRB.debug("Got principal '{}'.", (Object)subContext.getPrincipalName());
        }
    }

    private void lookupPrincipalAttributes(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        Attribute keyVersionNumberAttr;
        Dn principalDn = modContext.getDn();
        LookupOperationContext lookupContext = modContext.newLookupContext(principalDn, "objectClass", "krb5PrincipalName", "krb5KeyVersionNumber");
        lookupContext.setPartition(modContext.getPartition());
        lookupContext.setTransaction(modContext.getTransaction());
        Entry userEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        if (userEntry == null) {
            throw new LdapAuthenticationException(I18n.err(I18n.ERR_512, principalDn));
        }
        if (!((ClonedServerEntry)userEntry).getOriginalEntry().contains(this.directoryService.getAtProvider().getObjectClass(), "krb5Principal")) {
            return;
        }
        subContext.isPrincipal(true);
        LOG.debug("Dn {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getName());
        LOG_KRB.debug("Dn {} is a Kerberos principal.  Will attempt key derivation.", (Object)principalDn.getName());
        if (subContext.getPrincipalName() == null) {
            Attribute principalAttribute = ((ClonedServerEntry)userEntry).getOriginalEntry().get(this.krb5PrincipalNameAT);
            String principalName = principalAttribute.getString();
            subContext.setPrincipalName(principalName);
            LOG.debug("Found principal '{}' from lookup.", (Object)principalName);
            LOG_KRB.debug("Found principal '{}' from lookup.", (Object)principalName);
        }
        if ((keyVersionNumberAttr = ((ClonedServerEntry)userEntry).getOriginalEntry().get(this.krb5KeyVersionNumberAT)) == null) {
            subContext.setNewKeyVersionNumber(0);
            LOG.debug("Key version number was null, setting to 0.");
            LOG_KRB.debug("Key version number was null, setting to 0.");
        } else {
            int oldKeyVersionNumber = Integer.parseInt(keyVersionNumberAttr.getString());
            int newKeyVersionNumber = oldKeyVersionNumber + 1;
            subContext.setNewKeyVersionNumber(newKeyVersionNumber);
            LOG.debug("Found key version number '{}', setting to '{}'.", (Object)oldKeyVersionNumber, (Object)newKeyVersionNumber);
            LOG_KRB.debug("Found key version number '{}', setting to '{}'.", (Object)oldKeyVersionNumber, (Object)newKeyVersionNumber);
        }
    }

    void deriveKeys(ModifyOperationContext modContext, ModifySubContext subContext) throws LdapException {
        List<Modification> mods = modContext.getModItems();
        String principalName = subContext.getPrincipalName();
        String userPassword = subContext.getUserPassword();
        int kvno = subContext.getNewKeyVersionNumber();
        LOG.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        LOG_KRB.debug("Got principal '{}' with userPassword '{}'.", (Object)principalName, (Object)userPassword);
        Map<EncryptionType, EncryptionKey> keys = this.generateKeys(principalName, userPassword);
        ArrayList<Modification> newModsList = new ArrayList<Modification>();
        for (Modification mod : mods) {
            newModsList.add(mod);
        }
        DefaultModification krb5PrincipalName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute(this.krb5PrincipalNameAT, principalName));
        newModsList.add(krb5PrincipalName);
        DefaultModification krb5KeyVersionNumber = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute(this.krb5KeyVersionNumberAT, Integer.toString(kvno)));
        newModsList.add(krb5KeyVersionNumber);
        Attribute attribute = this.getKeyAttribute(keys);
        newModsList.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute));
        LOG.debug("Added two modifications to the current request : {} and {}", (Object)krb5PrincipalName, (Object)krb5KeyVersionNumber);
        LOG_KRB.debug("Added two modifications to the current request : {} and {}", (Object)krb5PrincipalName, (Object)krb5KeyVersionNumber);
        modContext.setModItems(newModsList);
    }

    private Attribute getKeyAttribute(Map<EncryptionType, EncryptionKey> keys) throws LdapException {
        DefaultAttribute keyAttribute = new DefaultAttribute(this.krb5KeyAT);
        for (EncryptionKey encryptionKey : keys.values()) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(encryptionKey.computeLength());
                encryptionKey.encode(buffer);
                keyAttribute.add(new byte[][]{buffer.array()});
            }
            catch (EncoderException ioe) {
                LOG.error(I18n.err(I18n.ERR_122, new Object[0]), ioe);
                LOG_KRB.error(I18n.err(I18n.ERR_122, new Object[0]), ioe);
            }
        }
        return keyAttribute;
    }

    private Map<EncryptionType, EncryptionKey> generateKeys(String principalName, String userPassword) {
        if (userPassword.equalsIgnoreCase("randomKey")) {
            try {
                return RandomKeyFactory.getRandomKeys();
            }
            catch (KerberosException ke) {
                LOG.debug(ke.getLocalizedMessage(), ke);
                LOG_KRB.debug(ke.getLocalizedMessage(), ke);
                return null;
            }
        }
        return KerberosKeyFactory.getKerberosKeys(principalName, userPassword);
    }

    static class ModifySubContext {
        private boolean isPrincipal = false;
        private String principalName;
        private String userPassword;
        private int newKeyVersionNumber = -1;

        ModifySubContext() {
        }

        boolean isPrincipal() {
            return this.isPrincipal;
        }

        void isPrincipal(boolean isPrincipal) {
            this.isPrincipal = isPrincipal;
        }

        String getPrincipalName() {
            return this.principalName;
        }

        void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        String getUserPassword() {
            return this.userPassword;
        }

        void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        int getNewKeyVersionNumber() {
            return this.newKeyVersionNumber;
        }

        void setNewKeyVersionNumber(int newKeyVersionNumber) {
            this.newKeyVersionNumber = newKeyVersionNumber;
        }

        boolean hasValues() {
            return this.userPassword != null && this.principalName != null && this.newKeyVersionNumber > -1;
        }
    }
}

