/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.mergepoint.MergepointSaxHandler;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class OutletSaxHandler
extends DefaultHandler {
    private static Log log = LogFactory.getLog(OutletSaxHandler.class);
    private QualifiedName outletName;
    private Outlet outlet;
    private ConfigurationProvider configurationProvider;
    private ProjectPaths projectPaths;
    private ConfigurationHandlers configurationHandlers;
    private MergepointSaxHandler mergepointSaxHandler;
    private boolean finished = false;
    private String startTagRawName = null;

    public OutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            log.error((Object)"OutletSaxHandler:  configurationProvider is null");
            throw new NullPointerException("configurationProvider is null");
        }
        if (projectPaths == null) {
            log.error((Object)"OutletSaxHandler:  projectPaths is null");
            throw new NullPointerException("projectPaths is null");
        }
        if (configurationHandlers == null) {
            log.error((Object)"OutletSaxHandler:  configurationHandlers is null");
            throw new NullPointerException("configurationHandlers is null");
        }
        this.outletName = outletName;
        this.configurationProvider = configurationProvider;
        this.projectPaths = projectPaths;
        this.configurationHandlers = configurationHandlers;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.startTagRawName == null) {
            this.startTagRawName = rawName;
            this.outlet = this.createOutlet(this.outletName, uri, localName, rawName, attributes);
        } else if ("input".equals(rawName)) {
            String element = attributes.getValue("elementName");
            if (element == null) {
                throw new SAXException("The attribute elementName must be set for the tag input");
            }
            this.outlet.setInputElementName(element);
        } else if ("mergepoint".equals(rawName)) {
            this.mergepointSaxHandler = new MergepointSaxHandler(this.configurationProvider, this.projectPaths, this.configurationHandlers);
            this.mergepointSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (this.mergepointSaxHandler != null) {
            this.mergepointSaxHandler.startElement(uri, localName, rawName, attributes);
        } else {
            throw new SAXException("unknown Element " + rawName);
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.mergepointSaxHandler != null) {
            this.mergepointSaxHandler.endElement(uri, localName, rawName);
            if (this.mergepointSaxHandler.isFinished()) {
                try {
                    this.outlet.addMergepointMapping(this.mergepointSaxHandler.getMergepointMapping());
                }
                catch (ConfigurationException e) {
                    throw new SAXException("Could not get mergepoint mapping from the mergepoint Sax handler", e);
                }
                this.mergepointSaxHandler = null;
            }
        } else if (this.startTagRawName.equals(rawName)) {
            this.finished = true;
        }
    }

    protected abstract Outlet createOutlet(QualifiedName var1, String var2, String var3, String var4, Attributes var5) throws SAXException;

    public Outlet getOutlet() {
        return this.outlet;
    }

    protected boolean isProcessingMergepointTag() {
        return this.mergepointSaxHandler != null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public ProjectPaths getProjectPaths() {
        return this.projectPaths;
    }

    public ConfigurationHandlers getConfigurationHandlers() {
        return this.configurationHandlers;
    }
}

