/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class DirectHll8Array
extends DirectHllArray {
    DirectHll8Array(int lgConfigK, MemorySegment wseg) {
        super(lgConfigK, TgtHllType.HLL_8, wseg);
    }

    DirectHll8Array(int lgConfigK, MemorySegment seg, boolean readOnly) {
        super(lgConfigK, TgtHllType.HLL_8, seg, readOnly);
    }

    @Override
    HllSketchImpl copy() {
        return Hll8Array.heapify(this.seg);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wseg == null) {
            HllUtil.noWriteAccess();
        }
        int newValue = HllUtil.getPairValue(coupon);
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getPairLow26(coupon) & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll8Array.hll8ArrBytes(this.lgConfigK);
    }

    @Override
    int getNibble(int slotNo) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    int getSlotValue(int slotNo) {
        return this.seg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + slotNo)) & 0x3F;
    }

    @Override
    PairIterator iterator() {
        return new DirectHll8Iterator(this, 1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotNoKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            this.wseg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + slotNo), (byte)(newValue & 0x3F));
        }
    }

    @Override
    void updateSlotWithKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            this.wseg.set(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + slotNo), (byte)(newValue & 0x3F));
            DirectHll8Array.hipAndKxQIncrementalUpdate(this, oldValue, newValue);
            if (oldValue == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
    }

    final class DirectHll8Iterator
    extends HllPairIterator {
        final /* synthetic */ DirectHll8Array this$0;

        DirectHll8Iterator(DirectHll8Array this$0, int lengthPairs) {
            DirectHll8Array directHll8Array = this$0;
            Objects.requireNonNull(directHll8Array);
            this.this$0 = directHll8Array;
            super(lengthPairs);
        }

        @Override
        int value() {
            byte tmp = this.this$0.seg.get(ValueLayout.JAVA_BYTE, (long)(PreambleUtil.HLL_BYTE_ARR_START + this.index));
            return tmp & 0x3F;
        }
    }
}

