/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyMemorySegmentTest {
    @Test
    public void wrapAndTryUpdatingUpdateSketch() {
        UpdatableThetaSketch updateSketch = UpdatableThetaSketch.builder().build();
        updateSketch.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(updateSketch.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        UpdatableThetaSketch sketch = (UpdatableThetaSketch)ThetaSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
        boolean thrown = false;
        try {
            sketch.update(2L);
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void wrapCompactUnorderedSketch() {
        UpdatableThetaSketch updateSketch = UpdatableThetaSketch.builder().build();
        updateSketch.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(updateSketch.compact(false, null).toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaSketch sketch = ThetaSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void wrapCompactOrderedSketch() {
        UpdatableThetaSketch updateSketch = UpdatableThetaSketch.builder().build();
        updateSketch.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(updateSketch.compact().toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaSketch sketch = ThetaSketch.wrap((MemorySegment)seg);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void heapifyUpdateSketch() {
        UpdatableThetaSketch us1 = UpdatableThetaSketch.builder().build();
        us1.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(us1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        UpdatableThetaSketch us2 = (UpdatableThetaSketch)ThetaSketch.heapify((MemorySegment)seg);
        us2.update(2L);
        Assert.assertEquals((double)us2.getEstimate(), (double)2.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void heapifyCompactUnorderedSketch() {
        UpdatableThetaSketch updateSketch = UpdatableThetaSketch.builder().build();
        updateSketch.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(updateSketch.compact(false, null).toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaSketch sketch = ThetaSketch.heapify((MemorySegment)seg);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void heapifyCompactOrderedSketch() {
        UpdatableThetaSketch updateSketch = UpdatableThetaSketch.builder().build();
        updateSketch.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(updateSketch.compact().toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaSketch sketch = ThetaSketch.heapify((MemorySegment)seg);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void heapifyUnion() {
        ThetaUnion u1 = ThetaSetOperation.builder().buildUnion();
        u1.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(u1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaUnion u2 = (ThetaUnion)ThetaSetOperation.heapify((MemorySegment)seg);
        u2.update(2L);
        Assert.assertEquals((double)u2.getResult().getEstimate(), (double)2.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void wrapAndTryUpdatingUnion() {
        ThetaUnion u1 = ThetaSetOperation.builder().buildUnion();
        u1.update(1L);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(u1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaUnion u2 = (ThetaUnion)ThetaSetOperation.wrap((MemorySegment)seg);
        ThetaUnion u3 = ThetaUnion.wrap((MemorySegment)seg);
        Assert.assertEquals((double)u2.getResult().getEstimate(), (double)1.0);
        Assert.assertEquals((double)u3.getResult().getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
        try {
            u2.update(2L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u3.update(2L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void heapifyIntersection() {
        UpdatableThetaSketch us1 = UpdatableThetaSketch.builder().build();
        us1.update(1L);
        us1.update(2L);
        UpdatableThetaSketch us2 = UpdatableThetaSketch.builder().build();
        us2.update(2L);
        us2.update(3L);
        ThetaIntersection i1 = ThetaSetOperation.builder().buildIntersection();
        i1.intersect((ThetaSketch)us1);
        i1.intersect((ThetaSketch)us2);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(i1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaIntersection i2 = (ThetaIntersection)ThetaSetOperation.heapify((MemorySegment)seg);
        i2.intersect((ThetaSketch)us1);
        Assert.assertEquals((double)i2.getResult().getEstimate(), (double)1.0);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void wrapIntersection() {
        UpdatableThetaSketch us1 = UpdatableThetaSketch.builder().build();
        us1.update(1L);
        us1.update(2L);
        UpdatableThetaSketch us2 = UpdatableThetaSketch.builder().build();
        us2.update(2L);
        us2.update(3L);
        ThetaIntersection i1 = ThetaSetOperation.builder().buildIntersection();
        i1.intersect((ThetaSketch)us1);
        i1.intersect((ThetaSketch)us2);
        MemorySegment seg = MemorySegment.ofBuffer(ByteBuffer.wrap(i1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        ThetaIntersection i2 = (ThetaIntersection)ThetaSetOperation.wrap((MemorySegment)seg);
        Assert.assertEquals((double)i2.getResult().getEstimate(), (double)1.0);
        boolean thrown = false;
        try {
            i2.intersect((ThetaSketch)us1);
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        Assert.assertTrue((boolean)seg.isReadOnly());
    }

    @Test
    public void printlnTest() {
        ReadOnlyMemorySegmentTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

