/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapifyWrapSerVer3Test {
    private static final short defaultSeedHash = Util.computeSeedHash((long)9001L);

    @Test
    public void checkHeapifyCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        MemorySegment cskSeg = MemorySegment.ofArray(csk.toByteArray()).asReadOnly();
        CompactThetaSketch cskResult = CompactThetaSketch.heapify((MemorySegment)cskSeg);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifyCompactSketchDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        MemorySegment cskSeg = MemorySegment.ofArray(csk.toByteArray()).asReadOnly();
        CompactThetaSketch cskResult = CompactThetaSketch.heapify((MemorySegment)cskSeg, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        MemorySegment cskSeg = MemorySegment.ofArray(csk.toByteArray()).asReadOnly();
        CompactThetaSketch cskResult = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)cskSeg);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        MemorySegment cskSeg = MemorySegment.ofArray(csk.toByteArray()).asReadOnly();
        CompactThetaSketch cskResult = (CompactThetaSketch)ThetaSketch.heapify((MemorySegment)cskSeg, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkWrapCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment offHeap = HeapifyWrapSerVer3Test.putOffHeap(MemorySegment.ofArray(csk.toByteArray()), arena);
            CompactThetaSketch cskResult = CompactThetaSketch.wrap((MemorySegment)offHeap);
            Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
            Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
            Assert.assertTrue((boolean)cskResult.isOffHeap());
        }
    }

    @Test
    public void checkWrapCompactSketchDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment offHeap = HeapifyWrapSerVer3Test.putOffHeap(MemorySegment.ofArray(csk.toByteArray()), arena);
            CompactThetaSketch cskResult = CompactThetaSketch.wrap((MemorySegment)offHeap, (long)128L);
            Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
            Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
            Assert.assertTrue((boolean)cskResult.isOffHeap());
        }
    }

    @Test
    public void checkWrapSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment offHeap = HeapifyWrapSerVer3Test.putOffHeap(MemorySegment.ofArray(csk.toByteArray()), arena);
            CompactThetaSketch cskResult = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)offHeap);
            Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
            Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
            Assert.assertTrue((boolean)cskResult.isOffHeap());
        }
    }

    @Test
    public void checkWrapSketchDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactThetaSketch csk = usk.compact();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment offHeap = HeapifyWrapSerVer3Test.putOffHeap(MemorySegment.ofArray(csk.toByteArray()), arena);
            CompactThetaSketch cskResult = (CompactThetaSketch)ThetaSketch.wrap((MemorySegment)offHeap, (long)128L);
            Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
            Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
            Assert.assertTrue((boolean)cskResult.isOffHeap());
        }
    }

    private static MemorySegment putOffHeap(MemorySegment heapSeg, Arena arena) {
        long cap = heapSeg.byteSize();
        MemorySegment wseg = arena.allocate(cap);
        MemorySegment.copy(heapSeg, 0L, wseg, 0L, cap);
        return wseg;
    }

    @Test
    public void printlnTest() {
        HeapifyWrapSerVer3Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

