/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.weaver.model.NestedWeavable;
import org.apache.commons.weaver.model.WeavableConstructor;
import org.apache.commons.weaver.model.WeavableField;
import org.apache.commons.weaver.model.WeavableMethod;
import org.apache.commons.weaver.model.WeavablePackage;
import org.apache.commons.weaver.utils.Args;

public class WeavableClass<T>
extends NestedWeavable<WeavableClass<T>, Class<T>, WeavablePackage, Package> {
    private static final Comparator<Class<?>> CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    private final ConcurrentNavigableMap<String, WeavableField<T>> fields = new ConcurrentSkipListMap<String, WeavableField<T>>();
    private final ConcurrentNavigableMap<Constructor<T>, WeavableConstructor<T>> ctors = new ConcurrentSkipListMap<Constructor<T>, WeavableConstructor<T>>((ctor1, ctor2) -> Args.compare(ctor1.getParameterTypes(), ctor2.getParameterTypes()));
    private final ConcurrentNavigableMap<Method, WeavableMethod<T>> methods = new ConcurrentSkipListMap<Method, WeavableMethod<T>>((methd1, methd2) -> {
        int result = methd1.getName().compareTo(methd2.getName());
        return result == 0 ? Args.compare(methd1.getParameterTypes(), methd2.getParameterTypes()) : result;
    });

    public WeavableClass(Class<T> target, WeavablePackage parent) {
        super(target, parent);
    }

    public WeavableField<T> getWeavable(Field fld) {
        return this.fields.computeIfAbsent(fld.getName(), k -> new WeavableField(fld, this));
    }

    public WeavableMethod<T> getWeavable(Method methd) {
        return this.methods.computeIfAbsent(methd, k -> new WeavableMethod(methd, this));
    }

    public WeavableConstructor<T> getWeavable(Constructor<T> ctor) {
        return this.ctors.computeIfAbsent(ctor, k -> new WeavableConstructor(ctor, this));
    }

    public Iterable<WeavableField<T>> getFields() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    public Iterable<WeavableConstructor<T>> getConstructors() {
        return Collections.unmodifiableCollection(this.ctors.values());
    }

    public Iterable<WeavableMethod<T>> getMethods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    @Override
    protected int localCompareTo(WeavableClass<T> obj) {
        return obj == null ? 1 : CLASS_COMPARATOR.compare((Class<?>)this.getTarget(), (Class<?>)obj.getTarget());
    }
}

