/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    @Override
    public double evaluate(double[] values) throws MathIllegalArgumentException {
        MathArrays.verifyValues((double[])values, (int)0, (int)0);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3) throws MathIllegalArgumentException;

    @Override
    public abstract UnivariateStatistic copy();

    public void setData(double[] values) {
        this.storedData = values == null ? null : (double[])values.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, (Number)begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, (Number)length);
        }
        if (begin + length > values.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), (Number)values.length, true);
        }
        this.storedData = new double[length];
        System.arraycopy(values, begin, this.storedData, 0, length);
    }

    public double evaluate() throws MathIllegalArgumentException {
        return this.evaluate(this.storedData);
    }
}

