/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.random;

import java.util.function.Supplier;
import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RectangularCholeskyDecomposition;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class CorrelatedVectorFactory {
    private static final double SQRT3 = JdkMath.sqrt((double)3.0);
    private final double[] mean;
    private final RealMatrix root;
    private final int lengthUncorrelated;
    private final int lengthCorrelated;

    public CorrelatedVectorFactory(double[] mean, RealMatrix covariance, double small) {
        this.lengthCorrelated = covariance.getRowDimension();
        if (mean.length != this.lengthCorrelated) {
            throw new DimensionMismatchException(mean.length, this.lengthCorrelated);
        }
        this.mean = (double[])mean.clone();
        RectangularCholeskyDecomposition decomposition = new RectangularCholeskyDecomposition(covariance, small);
        this.root = decomposition.getRootMatrix();
        this.lengthUncorrelated = decomposition.getRank();
    }

    public CorrelatedVectorFactory(RealMatrix covariance, double small) {
        this(new double[covariance.getRowDimension()], covariance, small);
    }

    public Supplier<double[]> uniform(UniformRandomProvider rng) {
        return this.with((ContinuousSampler)new ContinuousUniformSampler(rng, -SQRT3, SQRT3));
    }

    public Supplier<double[]> gaussian(UniformRandomProvider rng) {
        return this.with((ContinuousSampler)new ZigguratNormalizedGaussianSampler(rng));
    }

    private Supplier<double[]> with(final ContinuousSampler sampler) {
        return new Supplier<double[]>(){

            @Override
            public double[] get() {
                double[] uncorrelated = new double[CorrelatedVectorFactory.this.lengthUncorrelated];
                for (int i = 0; i < CorrelatedVectorFactory.this.lengthUncorrelated; ++i) {
                    uncorrelated[i] = sampler.sample();
                }
                double[] correlated = (double[])CorrelatedVectorFactory.this.mean.clone();
                for (int i = 0; i < correlated.length; ++i) {
                    for (int j = 0; j < CorrelatedVectorFactory.this.lengthUncorrelated; ++j) {
                        int n = i;
                        correlated[n] = correlated[n] + CorrelatedVectorFactory.this.root.getEntry(i, j) * uncorrelated[j];
                    }
                }
                return correlated;
            }
        };
    }
}

