/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim;

import java.util.Arrays;
import org.apache.commons.math4.legacy.core.Pair;

public final class PointValuePair
extends Pair<double[], Double> {
    public PointValuePair(double[] point, double value) {
        this(point, value, true);
    }

    public PointValuePair(double[] point, double value, boolean copyArray) {
        super(copyArray ? (Object)(point == null ? null : (double[])point.clone()) : point, (Object)value);
    }

    public double[] getPoint() {
        double[] p = (double[])this.getKey();
        return p == null ? null : (double[])p.clone();
    }

    public double[] getPointRef() {
        return (double[])this.getKey();
    }

    public boolean equals(Object o) {
        if (o instanceof PointValuePair) {
            PointValuePair other = (PointValuePair)((Object)o);
            return ((Double)this.getValue()).equals(other.getValue()) && Arrays.equals(this.getPointRef(), other.getPointRef());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode((double[])this.getKey()) + 31 * Double.hashCode((Double)this.getValue());
    }

    public String toString() {
        return "[" + Arrays.toString(this.getPointRef()) + ", " + this.getValue() + "]";
    }
}

