/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class AncestorContext
extends EvalContext {
    private final NodeTest nodeTest;
    private boolean setStarted;
    private NodePointer currentNodePointer;
    private final boolean includeSelf;

    public AncestorContext(EvalContext parentContext, boolean includeSelf, NodeTest nodeTest) {
        super(parentContext);
        this.includeSelf = includeSelf;
        this.nodeTest = nodeTest;
    }

    @Override
    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    @Override
    public int getDocumentOrder() {
        return -1;
    }

    @Override
    public boolean nextNode() {
        if (!this.setStarted) {
            this.setStarted = true;
            this.currentNodePointer = this.parentContext.getCurrentNodePointer();
            if (this.includeSelf && this.currentNodePointer.testNode(this.nodeTest)) {
                ++this.position;
                return true;
            }
        }
        do {
            this.currentNodePointer = this.currentNodePointer.getImmediateParentPointer();
            if (this.currentNodePointer != null) continue;
            return false;
        } while (!this.currentNodePointer.testNode(this.nodeTest));
        ++this.position;
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.setStarted = false;
    }

    @Override
    public boolean setPosition(int position) {
        if (position < this.getCurrentPosition()) {
            this.reset();
        }
        while (this.getCurrentPosition() < position) {
            if (this.nextNode()) continue;
            return false;
        }
        return true;
    }
}

