/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.HashMap;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NestedTestBean;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.TestNull;
import org.apache.commons.jxpath.ri.axes.TestBeanWithNode;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.VariablePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.CollectionPointer;
import org.apache.commons.jxpath.ri.model.beans.NullElementPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.TestBeanFactory;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimplePathInterpreterTest {
    private TestBeanWithNode bean;
    private JXPathContext context;

    private void assertNullPointer(String path, String expectedPath, String expectedSignature) {
        Pointer pointer = this.context.getPointer(path);
        Assertions.assertNotNull((Object)pointer, (String)("Null path exists: " + path));
        Assertions.assertEquals((Object)expectedPath, (Object)pointer.asPath(), (String)("Null path as path: " + path));
        Assertions.assertEquals((Object)expectedSignature, (Object)this.pointerSignature(pointer), (String)("Checking Signature: " + path));
        NodePointer vPointer = ((NodePointer)pointer).getValuePointer();
        Assertions.assertFalse((boolean)vPointer.isActual(), (String)("Null path is null: " + path));
        Assertions.assertEquals((Object)(expectedSignature + "N"), (Object)this.pointerSignature((Pointer)vPointer), (String)("Checking value pointer signature: " + path));
    }

    private void assertValueAndPointer(String path, Object expectedValue, String expectedPath, String expectedSignature) {
        this.assertValueAndPointer(path, expectedValue, expectedPath, expectedSignature, expectedSignature);
    }

    private void assertValueAndPointer(String path, Object expectedValue, String expectedPath, String expectedSignature, String expectedValueSignature) {
        Object value = this.context.getValue(path);
        Assertions.assertEquals((Object)expectedValue, (Object)value, (String)("Checking value: " + path));
        Pointer pointer = this.context.getPointer(path);
        Assertions.assertEquals((Object)expectedPath, (Object)pointer.toString(), (String)("Checking pointer: " + path));
        Assertions.assertEquals((Object)expectedSignature, (Object)this.pointerSignature(pointer), (String)("Checking signature: " + path));
        NodePointer vPointer = ((NodePointer)pointer).getValuePointer();
        Assertions.assertEquals((Object)expectedValueSignature, (Object)this.pointerSignature((Pointer)vPointer), (String)("Checking value pointer signature: " + path));
    }

    private String pointerSignature(Pointer pointer) {
        if (pointer == null) {
            return "";
        }
        int type = 63;
        if (pointer instanceof NullPointer) {
            type = 78;
        } else if (pointer instanceof NullPropertyPointer) {
            type = 110;
        } else if (pointer instanceof NullElementPointer) {
            type = 69;
        } else if (pointer instanceof VariablePointer) {
            type = 86;
        } else if (pointer instanceof CollectionPointer) {
            type = 67;
        } else if (pointer instanceof BeanPointer) {
            type = 66;
        } else if (pointer instanceof BeanPropertyPointer) {
            type = 98;
        } else if (pointer instanceof DynamicPointer) {
            type = 68;
        } else if (pointer instanceof DynamicPropertyPointer) {
            type = 100;
        } else if (pointer instanceof DOMNodePointer) {
            type = 77;
        } else {
            System.err.println("UNKNOWN TYPE: " + pointer.getClass());
        }
        NodePointer parent = ((NodePointer)pointer).getImmediateParentPointer();
        return this.pointerSignature((Pointer)parent) + (char)type;
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.bean = TestBeanWithNode.createTestBeanWithDOM();
        HashMap<String, Object> submap = new HashMap<String, Object>();
        submap.put("key", new NestedTestBean("Name 9"));
        submap.put("strings", this.bean.getNestedBean().getStrings());
        this.bean.getList().add(new int[]{1, 2});
        this.bean.getList().add(this.bean.getVendor());
        this.bean.getMap().put("Key3", new Object[]{new NestedTestBean("some"), 2, this.bean.getVendor(), submap});
        this.bean.getMap().put("Key4", this.bean.getVendor());
        this.bean.getMap().put("Key5", submap);
        this.bean.getMap().put("Key6", new Object[0]);
        this.context = JXPathContext.newContext(null, (Object)this.bean);
        this.context.setLenient(true);
        this.context.setFactory((AbstractFactory)new TestBeanFactory());
    }

    @Test
    public void testDoPredicateIndex() {
        this.assertValueAndPointer("/map[@name='Key2'][@name='strings'][2]", "String 2", "/map[@name='Key2']/strings[2]", "BbDdBb", "BbDdBbB");
        this.assertValueAndPointer("/nestedBean[@name='strings'][2]", this.bean.getNestedBean().getStrings()[1], "/nestedBean/strings[2]", "BbBb", "BbBbB");
        this.assertNullPointer("/nestedBean[@name='foo'][3]", "/nestedBean[@name='foo'][3]", "BbBn");
        this.assertNullPointer("/nestedBean[@name='strings'][5]", "/nestedBean/strings[5]", "BbBbE");
        this.assertValueAndPointer("/map[@name='Key3'][2]", 2, "/map[@name='Key3'][2]", "BbDd", "BbDdB");
        this.assertNullPointer("/map[@name='Key3'][5]", "/map[@name='Key3'][5]", "BbDdE");
        this.assertNullPointer("/map[@name='Key3'][5]/foo", "/map[@name='Key3'][5]/foo", "BbDdENn");
        this.assertValueAndPointer("/map[@name='Key5'][@name='strings'][2]", "String 2", "/map[@name='Key5'][@name='strings'][2]", "BbDdDd", "BbDdDdB");
        this.assertNullPointer("/map[@name='Key5'][@name='strings'][5]", "/map[@name='Key5'][@name='strings'][5]", "BbDdDdE");
        this.assertValueAndPointer("/map[@name='Key3'][2]", 2, "/map[@name='Key3'][2]", "BbDd", "BbDdB");
        this.assertValueAndPointer("/map[@name='Key3'][1]/name", "some", "/map[@name='Key3'][1]/name", "BbDdBb", "BbDdBbB");
        this.assertNullPointer("/map[@name='foo'][3]", "/map[@name='foo'][3]", "BbDdE");
        this.assertValueAndPointer("/integers[2]", 2, "/integers[2]", "Bb", "BbB");
        this.assertValueAndPointer("/nestedBean/strings[2]", this.bean.getNestedBean().getStrings()[1], "/nestedBean/strings[2]", "BbBb", "BbBbB");
        this.assertValueAndPointer("/list[3]/int", 1, "/list[3]/int", "BbBb", "BbBbB");
        this.assertNullPointer("/list[6]", "/list[6]", "BbE");
        this.assertNullPointer("/nestedBean/foo[3]", "/nestedBean/foo[3]", "BbBn");
        this.assertNullPointer("/map/foo[3]", "/map[@name='foo'][3]", "BbDdE");
        this.assertNullPointer("/nestedBean/strings[5]", "/nestedBean/strings[5]", "BbBbE");
        this.assertNullPointer("/map/Key3[5]/foo", "/map[@name='Key3'][5]/foo", "BbDdENn");
        this.assertValueAndPointer("/map[@name='Key5']/strings[2]", "String 2", "/map[@name='Key5'][@name='strings'][2]", "BbDdDd", "BbDdDdB");
        this.assertNullPointer("/map[@name='Key5']/strings[5]", "/map[@name='Key5'][@name='strings'][5]", "BbDdDdE");
        this.assertValueAndPointer("/int[1]", 1, "/int", "Bb", "BbB");
        this.assertValueAndPointer(".[1]/int", 1, "/int", "Bb", "BbB");
    }

    @Test
    public void testDoPredicateName() {
        this.assertValueAndPointer("/nestedBean[@name='int']", 1, "/nestedBean/int", "BbBb", "BbBbB");
        this.assertValueAndPointer("/.[@name='int']", 1, "/int", "Bb", "BbB");
        this.assertValueAndPointer("/map[@name='Key1']", "Value 1", "/map[@name='Key1']", "BbDd", "BbDdB");
        this.assertValueAndPointer("/nestedBean[@name='strings']", this.bean.getNestedBean().getStrings(), "/nestedBean/strings", "BbBb", "BbBbC");
        this.assertNullPointer("/nestedBean[@name='foo']", "/nestedBean[@name='foo']", "BbBn");
        this.assertValueAndPointer("/map[@name='Key3']", this.bean.getMap().get("Key3"), "/map[@name='Key3']", "BbDd", "BbDdC");
        this.assertNullPointer("/map[@name='foo']", "/map[@name='foo']", "BbDd");
        this.assertValueAndPointer("/list[@name='fruitco']", this.context.getValue("/vendor"), "/list[5]", "BbCM");
        this.assertValueAndPointer("/map/Key3[@name='key']/name", "Name 9", "/map[@name='Key3'][4][@name='key']/name", "BbDdCDdBb", "BbDdCDdBbB");
        this.assertValueAndPointer("map/Key3[@name='fruitco']", this.context.getValue("/vendor"), "/map[@name='Key3'][3]", "BbDdCM");
        this.assertValueAndPointer("/vendor[@name='fruitco']", this.context.getValue("/vendor"), "/vendor", "BbM");
        this.assertNullPointer("/vendor[@name='foo']", "/vendor[@name='foo']", "BbMn");
        this.assertNullPointer("/vendor[@name='foo'][3]", "/vendor[@name='foo'][3]", "BbMn");
        this.assertNullPointer("/nestedBean[@name='foo']/bar", "/nestedBean[@name='foo']/bar", "BbBnNn");
        this.assertNullPointer("/map[@name='foo']/bar", "/map[@name='foo']/bar", "BbDdNn");
        this.assertNullPointer("/vendor[@name='foo']/bar", "/vendor[@name='foo']/bar", "BbMnNn");
        this.assertNullPointer("/vendor[@name='foo'][3]/bar", "/vendor[@name='foo'][3]/bar", "BbMnNn");
        this.assertValueAndPointer("/map[@name='Key2'][@name='name']", "Name 6", "/map[@name='Key2']/name", "BbDdBb", "BbDdBbB");
        this.assertValueAndPointer("/map[@name='Key2'][@name='strings'][2]", "String 2", "/map[@name='Key2']/strings[2]", "BbDdBb", "BbDdBbB");
        this.assertValueAndPointer("map[@name='Key5'][@name='key']/name", "Name 9", "/map[@name='Key5'][@name='key']/name", "BbDdDdBb", "BbDdDdBbB");
        this.assertNullPointer("map[@name='Key2'][@name='foo']", "/map[@name='Key2'][@name='foo']", "BbDdBn");
        this.assertNullPointer("map[@name='Key2'][@name='foo'][@name='bar']", "/map[@name='Key2'][@name='foo'][@name='bar']", "BbDdBnNn");
        this.assertValueAndPointer("map[@name='Key4'][@name='fruitco']", this.context.getValue("/vendor"), "/map[@name='Key4']", "BbDdM");
    }

    @Test
    public void testDoPredicatesStandard() {
        this.assertValueAndPointer("map[@name='Key3'][@name='fruitco']", this.context.getValue("/vendor"), "/map[@name='Key3'][3]", "BbDdCM");
        this.assertNullPointer("map[@name='Key3'][@name='foo']", "/map[@name='Key3'][4][@name='foo']", "BbDdCDd");
        this.assertValueAndPointer("map[@name='Key4'][@name='fruitco']", this.context.getValue("/vendor"), "/map[@name='Key4']", "BbDdM");
        this.assertNullPointer("map[@name='Key6'][@name='fruitco']", "/map[@name='Key6'][@name='fruitco']", "BbDdCn");
        this.assertValueAndPointer("/vendor/contact[@name='jack'][2]", "Jack Black", "/vendor/contact[4]", "BbMM");
        this.assertNullPointer("/vendor/contact[@name='jack'][5]", "/vendor/contact[@name='jack'][5]", "BbMnNn");
        this.assertValueAndPointer("/vendor/contact/.[@name='jack']", "Jack", "/vendor/contact[2]", "BbMM");
    }

    @Test
    public void testDoStepNoPredicatesPropertyOwner() {
        this.assertValueAndPointer("/int", 1, "/int", "Bb", "BbB");
        this.assertValueAndPointer("/./int", 1, "/int", "Bb", "BbB");
        this.assertNullPointer("/foo", "/foo", "Bn");
        this.assertValueAndPointer("/nestedBean/int", 1, "/nestedBean/int", "BbBb", "BbBbB");
        this.assertValueAndPointer("/nestedBean/strings", this.bean.getNestedBean().getStrings(), "/nestedBean/strings", "BbBb", "BbBbC");
        this.assertNullPointer("/nestedBean/foo", "/nestedBean/foo", "BbBn");
        this.assertNullPointer("/map/foo", "/map[@name='foo']", "BbDd");
        this.assertValueAndPointer("/list/int", 1, "/list[3]/int", "BbBb", "BbBbB");
        this.assertNullPointer("/list/foo", "/list[1]/foo", "BbBn");
        this.assertNullPointer("/nestedBean/foo/bar", "/nestedBean/foo/bar", "BbBnNn");
        this.assertNullPointer("/list/int/bar", "/list[3]/int/bar", "BbBbBn");
        this.assertNullPointer("/list/foo/bar", "/list[1]/foo/bar", "BbBnNn");
        this.assertNullPointer("/map/foo/bar", "/map[@name='foo']/bar", "BbDdNn");
        this.assertValueAndPointer("/map/Key1", "Value 1", "/map[@name='Key1']", "BbDd", "BbDdB");
        this.assertValueAndPointer("/integers", this.bean.getIntegers(), "/integers", "Bb", "BbC");
    }

    @Test
    public void testDoStepNoPredicatesStandard() {
        this.assertValueAndPointer("/vendor/location/address/city", "Fruit Market", "/vendor/location[2]/address[1]/city[1]", "BbMMMM");
        this.assertNullPointer("/vendor/location/address/pity", "/vendor/location[1]/address[1]/pity", "BbMMMn");
        this.assertNullPointer("/vendor/location/address/itty/bitty", "/vendor/location[1]/address[1]/itty/bitty", "BbMMMnNn");
        this.assertNullPointer("/vendor/location/address/city/pretty", "/vendor/location[2]/address[1]/city[1]/pretty", "BbMMMMn");
    }

    @Test
    public void testDoStepPredicatesPropertyOwner() {
        this.assertNullPointer("/foo[@name='foo']", "/foo[@name='foo']", "BnNn");
        this.assertNullPointer("/foo[3]", "/foo[3]", "Bn");
    }

    @Test
    public void testDoStepPredicatesStandard() {
        this.assertValueAndPointer("/vendor/contact[@name='jack']", "Jack", "/vendor/contact[2]", "BbMM");
        this.assertValueAndPointer("/vendor/contact[2]", "Jack", "/vendor/contact[2]", "BbMM");
        this.assertNullPointer("/vendor/contact[5]", "/vendor/contact[5]", "BbMn");
        this.assertValueAndPointer("/vendor/contact[@name='jack'][2]", "Jack Black", "/vendor/contact[4]", "BbMM");
        this.assertValueAndPointer("/vendor/contact[@name='jack'][2]", "Jack Black", "/vendor/contact[4]", "BbMM");
    }

    @Test
    public void testInterpretExpressionPath() {
        this.context.getVariables().declareVariable("array", (Object)new String[]{"Value1"});
        this.context.getVariables().declareVariable("testnull", (Object)new TestNull());
        this.assertNullPointer("$testnull/nothing[2]", "$testnull/nothing[2]", "VBbE");
    }
}

