/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AsyncQueryRunner;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AsyncQueryRunnerTest {
    AsyncQueryRunner runner;
    ArrayHandler handler;
    @Mock
    DataSource dataSource;
    @Mock
    Connection conn;
    @Mock
    PreparedStatement prepStmt;
    @Mock
    Statement stmt;
    @Mock
    ParameterMetaData meta;
    @Mock
    ResultSet results;

    private void callBatchWithException(String sql, Object[][] params) throws Exception {
        Future future = null;
        boolean caught = false;
        try {
            future = this.runner.batch(sql, params);
            future.get();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callGoodBatch(Connection conn, Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Future future = this.runner.batch(conn, "select * from blah where ? = ?", params);
        future.get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodBatch(Object[][] params) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        Future future = this.runner.batch("select * from blah where ? = ?", params);
        future.get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
    }

    private void callGoodQuery() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "select * from blah where ? = ?";
        this.runner.query(sql, (ResultSetHandler)this.handler, new Object[]{"unit", "test"}).get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        sql = "select * from blah";
        this.runner.query(sql, (ResultSetHandler)this.handler).get();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery(sql);
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
    }

    private void callGoodQuery(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "select * from blah where ? = ?";
        this.runner.query(conn, sql, (ResultSetHandler)this.handler, new Object[]{"unit", "test"}).get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        sql = "select * from blah";
        this.runner.query(conn, sql, (ResultSetHandler)this.handler).get();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeQuery(sql);
        ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)2))).close();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callGoodUpdate() throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "update blah set ? = ?";
        this.runner.update(sql, new Object[]{"unit", "test"}).get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        sql = "update blah set unit = test";
        this.runner.update(sql).get();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate(sql);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        this.runner.update("update blah set unit = ?", (Object)"test").get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).close();
    }

    private void callGoodUpdate(Connection conn) throws Exception {
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
        String sql = "update blah set ? = ?";
        this.runner.update(conn, sql, new Object[]{"unit", "test"}).get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)0);
        sql = "update blah set unit = test";
        this.runner.update(conn, sql).get();
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).executeUpdate(sql);
        ((Statement)Mockito.verify((Object)this.stmt, (VerificationMode)Mockito.times((int)1))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)1);
        sql = "update blah set unit = ?";
        this.runner.update(conn, sql, (Object)"test").get();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)2))).close();
        ((Connection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)0))).close();
    }

    private void callQueryWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, params).get();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((ResultSet)Mockito.verify((Object)this.results, (VerificationMode)Mockito.times((int)1))).close();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    private void callUpdateWithException(Object ... params) throws Exception {
        boolean caught = false;
        try {
            Mockito.when((Object)this.meta.getParameterCount()).thenReturn((Object)2);
            this.runner.update("select * from blah where ? = ?", params).get();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)this.prepStmt, (VerificationMode)Mockito.times((int)1))).close();
            ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            Assert.fail((String)"Exception never thrown, but expected");
        }
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.conn.prepareStatement((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.prepStmt);
        Mockito.when((Object)this.prepStmt.getParameterMetaData()).thenReturn((Object)this.meta);
        Mockito.when((Object)this.prepStmt.executeQuery()).thenReturn((Object)this.results);
        Mockito.when((Object)this.conn.createStatement()).thenReturn((Object)this.stmt);
        Mockito.when((Object)this.stmt.executeQuery((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.results);
        Mockito.when((Object)this.results.next()).thenReturn((Object)false);
        this.handler = new ArrayHandler();
        this.runner = new AsyncQueryRunner(Executors.newFixedThreadPool(1), new QueryRunner(this.dataSource));
    }

    @Test
    public void testAddBatchException() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test(expected=ExecutionException.class)
    public void testBadPrepareConnection() throws Exception {
        this.runner = new AsyncQueryRunner(Executors.newFixedThreadPool(1));
        this.runner.update("update blah set unit = test").get();
    }

    @Test
    public void testExecuteBatchException() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testExecuteQueryException() throws Exception {
        this.callQueryWithException(this.handler, "unit", "test");
    }

    @Test
    public void testExecuteUpdateException() throws Exception {
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.prepStmt)).executeUpdate();
        this.callUpdateWithException("unit", "test");
    }

    @Test
    public void testGoodBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params);
    }

    @Test
    public void testGoodBatchDefaultConstructor() throws Exception {
        this.runner = new AsyncQueryRunner(Executors.newFixedThreadPool(1));
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(this.conn, params);
    }

    @Test
    public void testGoodBatchPmdTrue() throws Exception {
        this.runner = new AsyncQueryRunner(this.dataSource, true, Executors.newFixedThreadPool(1));
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.callGoodBatch(params);
    }

    @Test
    public void testGoodQuery() throws Exception {
        this.callGoodQuery();
    }

    @Test
    public void testGoodQueryDefaultConstructor() throws Exception {
        this.runner = new AsyncQueryRunner(Executors.newFixedThreadPool(1));
        this.callGoodQuery(this.conn);
    }

    @Test
    public void testGoodQueryPmdTrue() throws Exception {
        this.runner = new AsyncQueryRunner(true, Executors.newFixedThreadPool(1));
        this.callGoodQuery(this.conn);
    }

    @Test
    public void testGoodUpdate() throws Exception {
        this.callGoodUpdate();
    }

    @Test
    public void testGoodUpdateDefaultConstructor() throws Exception {
        this.runner = new AsyncQueryRunner(Executors.newFixedThreadPool(1));
        this.callGoodUpdate(this.conn);
    }

    @Test
    public void testGoodUpdatePmdTrue() throws Exception {
        this.runner = new AsyncQueryRunner(true, Executors.newFixedThreadPool(1));
        this.callGoodUpdate(this.conn);
    }

    @Test
    public void testInsertUsesGivenQueryRunner() throws Exception {
        QueryRunner mockQueryRunner = (QueryRunner)Mockito.mock(QueryRunner.class, (MockSettings)Mockito.withSettings().verboseLogging());
        this.runner = new AsyncQueryRunner(Executors.newSingleThreadExecutor(), mockQueryRunner);
        this.runner.insert("1", (ResultSetHandler)this.handler);
        this.runner.insert("2", (ResultSetHandler)this.handler, new Object[]{"param1"});
        this.runner.insert(this.conn, "3", (ResultSetHandler)this.handler);
        this.runner.insert(this.conn, "4", (ResultSetHandler)this.handler, new Object[]{"param1"});
        TimeUnit.MILLISECONDS.sleep(50L);
        ((QueryRunner)Mockito.verify((Object)mockQueryRunner)).insert("1", (ResultSetHandler)this.handler);
        ((QueryRunner)Mockito.verify((Object)mockQueryRunner)).insert("2", (ResultSetHandler)this.handler, new Object[]{"param1"});
        ((QueryRunner)Mockito.verify((Object)mockQueryRunner)).insert(this.conn, "3", (ResultSetHandler)this.handler);
        ((QueryRunner)Mockito.verify((Object)mockQueryRunner)).insert(this.conn, "4", (ResultSetHandler)this.handler, new Object[]{"param1"});
    }

    @Test
    public void testNoParamsQuery() throws Exception {
        this.callGoodQuery();
    }

    @Test
    public void testNoParamsUpdate() throws Exception {
        this.callGoodUpdate();
    }

    @Test(expected=ExecutionException.class)
    public void testNullConnectionBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.batch("select * from blah where ? = ?", params).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullConnectionQuery() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.query("select * from blah where ? = ?", (ResultSetHandler)this.handler, new Object[]{"unit", "test"}).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullConnectionUpdate() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(null);
        this.runner.update("select * from blah where ? = ?", new Object[]{"unit", "test"}).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullHandlerQuery() throws Exception {
        this.runner.query("select * from blah where ? = ?", null).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullParamsArgBatch() throws Exception {
        this.runner.batch("select * from blah where ? = ?", null).get();
    }

    @Test
    public void testNullParamsBatch() throws Exception {
        Object[][] params = new String[][]{{null, "unit"}, {"test", null}};
        this.callGoodBatch(params);
    }

    @Test(expected=ExecutionException.class)
    public void testNullSqlBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit"}, {"test", "test"}};
        this.runner.batch(null, params).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullSqlQuery() throws Exception {
        this.runner.query(null, (ResultSetHandler)this.handler).get();
    }

    @Test(expected=ExecutionException.class)
    public void testNullSqlUpdate() throws Exception {
        this.runner.update(null).get();
    }

    @Test
    public void testTooFewParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit"}, {"test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testTooFewParamsQuery() throws Exception {
        this.callQueryWithException("unit");
    }

    @Test
    public void testTooFewParamsUpdate() throws Exception {
        this.callUpdateWithException("unit");
    }

    @Test
    public void testTooManyParamsBatch() throws Exception {
        Object[][] params = new String[][]{{"unit", "unit", "unit"}, {"test", "test", "test"}};
        this.callBatchWithException("select * from blah where ? = ?", params);
    }

    @Test
    public void testTooManyParamsQuery() throws Exception {
        this.callQueryWithException("unit", "test", "fail");
    }

    @Test
    public void testTooManyParamsUpdate() throws Exception {
        this.callUpdateWithException("unit", "test", "fail");
    }
}

