/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeTemplateManager {
    public static final String STANDARD_SERVER_SUPERCLASS = "Standard Server Superclass";
    public static final String STANDARD_SERVER_SUBCLASS = "Standard Server Subclass";
    public static final String SINGLE_SERVER_CLASS = "Single Server Class";
    static final String STANDARD_CLIENT_SUPERCLASS = "Standard Client Superclass";
    static final String STANDARD_CLIENT_SUBCLASS = "Standard Client Subclass";
    private static final String STANDARD_EMBEDDABLE_SUPERCLASS = "Standard Embeddable Superclass";
    private static final String STANDARD_EMBEDDABLE_SUBCLASS = "Standard Embeddable Subclass";
    private static final String SINGLE_EMBEDDABLE_CLASS = "Single Embeddable Class";
    private static final String STANDARD_SERVER_DATAMAP_SUPERCLASS = "Standard Server DataMap Superclass";
    private static final String STANDARD_SERVER_DATAMAP_SUBCLASS = "Standard Server DataMap Subclass";
    private static final String STANDARD_CLIENT_DATAMAP_SUPERCLASS = "Standard Client DataMap Superclass";
    private static final String STANDARD_CLIENT_DATAMAP_SUBCLASS = "Standard Client DataMap Subclass";
    private static final String SINGLE_DATAMAP_CLASS = "Single DataMap Class";
    public static final String NODE_NAME = "codeTemplateManager";
    private List<String> defaultSubclassTemplates;
    private List<String> defaultSuperclassTemplates;
    private List<String> defaultClientSubclassTemplates;
    private List<String> defaultClientSuperclassTemplates;
    private Map<String, String> customTemplates;
    private Map<String, String> reverseCustomTemplate;
    private Map<String, String> defaultTemplates;
    private List<String> defaultEmbeddableTemplates;
    private List<String> defaultEmbeddableSuperclassTemplates;
    private List<String> defaultServerDataMapTemplates;
    private List<String> defaultServerDataMapSuperclassTemplates;
    private List<String> defaultClientDataMapTemplates;
    private List<String> defaultClientDataMapSuperclassTemplates;
    private Map<String, String> reverseDefaultsTemplates;
    private final Application application;
    private final Preferences templatePreferences;
    private static final Logger logger = LoggerFactory.getLogger(CodeTemplateManager.class);

    public Preferences getTemplatePreferences(Application application) {
        return application.getPreferencesNode(this.getClass(), NODE_NAME);
    }

    public CodeTemplateManager(Application application) {
        this.application = application;
        this.templatePreferences = this.getTemplatePreferences(application);
        this.defaultSuperclassTemplates = new ArrayList<String>(2);
        this.defaultSuperclassTemplates.add(STANDARD_SERVER_SUPERCLASS);
        this.defaultClientSuperclassTemplates = new ArrayList<String>();
        this.defaultClientSuperclassTemplates.add(STANDARD_CLIENT_SUPERCLASS);
        this.defaultSubclassTemplates = new ArrayList<String>(2);
        this.defaultSubclassTemplates.add(SINGLE_SERVER_CLASS);
        this.defaultSubclassTemplates.add(STANDARD_SERVER_SUBCLASS);
        this.defaultClientSubclassTemplates = new ArrayList<String>();
        this.defaultClientSubclassTemplates.add(STANDARD_CLIENT_SUBCLASS);
        this.defaultEmbeddableTemplates = new ArrayList<String>();
        this.defaultEmbeddableTemplates.add(STANDARD_EMBEDDABLE_SUBCLASS);
        this.defaultEmbeddableTemplates.add(SINGLE_EMBEDDABLE_CLASS);
        this.defaultEmbeddableSuperclassTemplates = new ArrayList<String>();
        this.defaultEmbeddableSuperclassTemplates.add(STANDARD_EMBEDDABLE_SUPERCLASS);
        this.defaultServerDataMapTemplates = new ArrayList<String>();
        this.defaultServerDataMapTemplates.add(STANDARD_SERVER_DATAMAP_SUBCLASS);
        this.defaultServerDataMapTemplates.add(SINGLE_DATAMAP_CLASS);
        this.defaultServerDataMapSuperclassTemplates = new ArrayList<String>();
        this.defaultServerDataMapSuperclassTemplates.add(STANDARD_SERVER_DATAMAP_SUPERCLASS);
        this.defaultClientDataMapTemplates = new ArrayList<String>();
        this.defaultClientDataMapTemplates.add(STANDARD_CLIENT_DATAMAP_SUBCLASS);
        this.defaultClientDataMapSuperclassTemplates = new ArrayList<String>();
        this.defaultClientDataMapSuperclassTemplates.add(STANDARD_CLIENT_DATAMAP_SUPERCLASS);
        this.updateCustomTemplates(this.getTemplatePreferences(application));
        this.reverseCustomTemplate = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.customTemplates.entrySet()) {
            this.reverseCustomTemplate.put(entry.getValue(), entry.getKey());
        }
        this.defaultTemplates = new HashMap<String, String>();
        this.defaultTemplates.put(STANDARD_SERVER_SUPERCLASS, "templates/v4_1/superclass.vm");
        this.defaultTemplates.put(STANDARD_CLIENT_SUPERCLASS, "templates/v4_1/client-superclass.vm");
        this.defaultTemplates.put(STANDARD_SERVER_SUBCLASS, "templates/v4_1/subclass.vm");
        this.defaultTemplates.put(STANDARD_CLIENT_SUBCLASS, "templates/v4_1/client-subclass.vm");
        this.defaultTemplates.put(SINGLE_SERVER_CLASS, "templates/v4_1/singleclass.vm");
        this.defaultTemplates.put(STANDARD_EMBEDDABLE_SUPERCLASS, "templates/v4_1/embeddable-superclass.vm");
        this.defaultTemplates.put(STANDARD_EMBEDDABLE_SUBCLASS, "templates/v4_1/embeddable-subclass.vm");
        this.defaultTemplates.put(SINGLE_EMBEDDABLE_CLASS, "templates/v4_1/embeddable-singleclass.vm");
        this.defaultTemplates.put(STANDARD_SERVER_DATAMAP_SUBCLASS, "templates/v4_1/datamap-subclass.vm");
        this.defaultTemplates.put(STANDARD_CLIENT_DATAMAP_SUBCLASS, "templates/v4_1/client-datamap-subclass.vm");
        this.defaultTemplates.put(SINGLE_DATAMAP_CLASS, "templates/v4_1/datamap-singleclass.vm");
        this.defaultTemplates.put(STANDARD_SERVER_DATAMAP_SUPERCLASS, "templates/v4_1/datamap-superclass.vm");
        this.defaultTemplates.put(STANDARD_CLIENT_DATAMAP_SUPERCLASS, "templates/v4_1/client-datamap-superclass.vm");
        this.reverseDefaultsTemplates = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaultTemplates.entrySet()) {
            this.reverseDefaultsTemplates.put(entry.getValue(), entry.getKey());
        }
    }

    public void updateCustomTemplates(Preferences preference) {
        String[] keys = new String[]{};
        try {
            keys = preference.childrenNames();
        }
        catch (BackingStoreException e) {
            logger.warn("Error reading preferences");
        }
        this.customTemplates = new HashMap<String, String>(keys.length, 1.0f);
        for (String key : keys) {
            FSPath path = new FSPath(preference.node(key));
            this.customTemplates.put(key, path.getPath());
        }
    }

    public String getTemplatePath(String name, Resource rootPath) {
        Object value = this.customTemplates.get(name);
        if (value != null) {
            try {
                if (rootPath != null) {
                    Path path = Paths.get(rootPath.getURL().toURI()).getParent();
                    value = path.relativize(Paths.get((String)value, new String[0]));
                }
                return value.toString();
            }
            catch (URISyntaxException e) {
                logger.warn("Path for template named '{}' could not be resolved", (Object)name);
            }
        }
        return (value = this.defaultTemplates.get(name)) != null ? value.toString() : null;
    }

    public String getNameByPath(String name, Path rootPath) {
        String normalizedPath;
        Path path = Paths.get(name, new String[0]);
        String string = normalizedPath = rootPath == null ? path.normalize().toString() : rootPath.resolve(path).normalize().toString();
        if (this.reverseCustomTemplate.containsKey(normalizedPath)) {
            return this.reverseCustomTemplate.get(normalizedPath);
        }
        String value = this.reverseDefaultsTemplates.get(name);
        if (value != null) {
            return value.toString();
        }
        String preparedName = this.prepareName(Paths.get(normalizedPath, new String[0]), this.templatePreferences);
        return this.addTemplate(normalizedPath, preparedName).getKey();
    }

    public FSPath addTemplate(String path, String name) {
        Preferences newNode = this.templatePreferences.node(name);
        FSPath fsPath = (FSPath)this.application.getCayenneProjectPreferences().getProjectDetailObject(FSPath.class, newNode);
        fsPath.setPath(path);
        return fsPath;
    }

    private String prepareName(Path path, Preferences templatePreferences) {
        String preparedName = path.getFileName().toString().replaceAll(".vm$", "");
        preparedName = preparedName + "_0";
        int j = 1;
        try {
            while (templatePreferences.nodeExists(preparedName)) {
                preparedName = preparedName.replaceAll("_.*[0-9]", "_" + j);
                ++j;
            }
        }
        catch (BackingStoreException e) {
            logger.warn("Error reading preferences");
        }
        return preparedName;
    }

    public Map<String, String> getCustomTemplates() {
        return this.customTemplates;
    }

    public List<String> getDefaultSubclassTemplates() {
        return this.defaultSubclassTemplates;
    }

    public List<String> getDefaultClientSubclassTemplates() {
        return this.defaultClientSubclassTemplates;
    }

    public List<String> getDefaultSuperclassTemplates() {
        return this.defaultSuperclassTemplates;
    }

    public List<String> getDefaultClientSuperclassTemplates() {
        return this.defaultClientSuperclassTemplates;
    }

    public List<String> getDefaultEmbeddableTemplates() {
        return this.defaultEmbeddableTemplates;
    }

    public List<String> getDefaultEmbeddableSuperclassTemplates() {
        return this.defaultEmbeddableSuperclassTemplates;
    }

    public List<String> getDefaultDataMapTemplates() {
        return this.defaultServerDataMapTemplates;
    }

    public List<String> getDefaultDataMapSuperclassTemplates() {
        return this.defaultServerDataMapSuperclassTemplates;
    }

    public List<String> getDefaultClientDataMapTemplates() {
        return this.defaultClientDataMapTemplates;
    }

    public List<String> getDefaultClientDataMapSuperclassTemplates() {
        return this.defaultClientDataMapSuperclassTemplates;
    }
}

