/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.api;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class ProtobufJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Message> {
    public ProtobufJsonHttpMessageConverter() {
        super(new MediaType("application", "json", StandardCharsets.UTF_8));
    }

    protected boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    protected Message readInternal(Class<? extends Message> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        Message message;
        InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), StandardCharsets.UTF_8);
        try {
            Message.Builder builder = (Message.Builder)clazz.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            JsonFormat.parser().ignoringUnknownFields().merge((Reader)reader, builder);
            message = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HttpMessageNotReadableException("Error reading Protobuf message", (Throwable)e, inputMessage);
            }
        }
        reader.close();
        return message;
    }

    protected void writeInternal(Message message, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            outputMessage.getBody().write(JsonFormat.printer().preservingProtoFieldNames().print((MessageOrBuilder)message).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new HttpMessageConversionException("Error writing Protobuf message", (Throwable)e);
        }
    }
}

