/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.profile;

import com.google.protobuf.ProtocolStringList;
import jakarta.persistence.EntityNotFoundException;
import jakarta.ws.rs.NotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.custos.core.mapper.user.AttributeUpdateMetadataMapper;
import org.apache.custos.core.mapper.user.GroupMapper;
import org.apache.custos.core.mapper.user.StatusUpdateMetadataMapper;
import org.apache.custos.core.mapper.user.UserProfileMapper;
import org.apache.custos.core.model.user.Group;
import org.apache.custos.core.model.user.UserGroupMembership;
import org.apache.custos.core.model.user.UserGroupMembershipType;
import org.apache.custos.core.model.user.UserProfile;
import org.apache.custos.core.repo.user.AttributeUpdateMetadataRepository;
import org.apache.custos.core.repo.user.GroupAttributeRepository;
import org.apache.custos.core.repo.user.GroupMembershipRepository;
import org.apache.custos.core.repo.user.GroupMembershipTypeRepository;
import org.apache.custos.core.repo.user.GroupRepository;
import org.apache.custos.core.repo.user.GroupRoleRepository;
import org.apache.custos.core.repo.user.GroupToGroupMembershipRepository;
import org.apache.custos.core.repo.user.StatusUpdateMetadataRepository;
import org.apache.custos.core.repo.user.UserAttributeRepository;
import org.apache.custos.core.repo.user.UserProfileRepository;
import org.apache.custos.core.repo.user.UserRoleRepository;
import org.apache.custos.core.user.profile.api.DefaultGroupMembershipTypes;
import org.apache.custos.core.user.profile.api.GetAllGroupsResponse;
import org.apache.custos.core.user.profile.api.GetAllUserProfilesResponse;
import org.apache.custos.core.user.profile.api.GetUpdateAuditTrailRequest;
import org.apache.custos.core.user.profile.api.GetUpdateAuditTrailResponse;
import org.apache.custos.core.user.profile.api.GroupMembership;
import org.apache.custos.core.user.profile.api.GroupRequest;
import org.apache.custos.core.user.profile.api.GroupToGroupMembership;
import org.apache.custos.core.user.profile.api.Status;
import org.apache.custos.core.user.profile.api.UserGroupMembershipTypeRequest;
import org.apache.custos.core.user.profile.api.UserProfileAttributeUpdateMetadata;
import org.apache.custos.core.user.profile.api.UserProfileRequest;
import org.apache.custos.core.user.profile.api.UserProfileStatusUpdateMetadata;
import org.apache.custos.service.exceptions.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserProfileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserProfileService.class);
    @Autowired
    private UserProfileRepository repository;
    @Autowired
    private StatusUpdateMetadataRepository statusUpdaterRepository;
    @Autowired
    private AttributeUpdateMetadataRepository attributeUpdateMetadataRepository;
    @Autowired
    private UserAttributeRepository userAttributeRepository;
    @Autowired
    private UserRoleRepository roleRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private GroupRoleRepository groupRoleRepository;
    @Autowired
    private GroupAttributeRepository groupAttributeRepository;
    @Autowired
    private GroupMembershipRepository groupMembershipRepository;
    @Autowired
    private GroupToGroupMembershipRepository groupToGroupMembershipRepository;
    @Autowired
    private GroupMembershipTypeRepository groupMembershipTypeRepository;

    public org.apache.custos.core.user.profile.api.UserProfile createUserProfile(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to createUserProfile for " + request.getProfile().getUsername() + "at " + request.getTenantId());
            String userId = request.getProfile().getUsername() + "@" + request.getTenantId();
            Optional op = this.repository.findById((Object)userId);
            if (op.isEmpty()) {
                UserProfile entity = UserProfileMapper.createUserProfileEntityFromUserProfile((org.apache.custos.core.user.profile.api.UserProfile)request.getProfile());
                entity.setId(userId);
                entity.setTenantId(Long.valueOf(request.getTenantId()));
                this.repository.save((Object)entity);
            }
            return request.getProfile();
        }
        catch (Exception ex) {
            String msg = "Error occurred while creating user profile for " + request.getProfile().getUsername() + "at " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.user.profile.api.UserProfile updateUserProfile(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to updateUserProfile for " + request.getProfile().getUsername() + "at " + request.getTenantId());
            String userId = request.getProfile().getUsername() + "@" + request.getTenantId();
            Optional exEntity = this.repository.findById((Object)userId);
            if (exEntity.isPresent()) {
                UserProfile entity = UserProfileMapper.createUserProfileEntityFromUserProfile((org.apache.custos.core.user.profile.api.UserProfile)request.getProfile());
                Set metadata = AttributeUpdateMetadataMapper.createAttributeUpdateMetadataEntity((UserProfile)((UserProfile)exEntity.get()), (UserProfile)entity, (String)request.getPerformedBy());
                entity.setAttributeUpdateMetadata(metadata);
                entity.setId(userId);
                entity.setTenantId(Long.valueOf(request.getTenantId()));
                entity.setCreatedAt(((UserProfile)exEntity.get()).getCreatedAt());
                UserProfile exProfile = (UserProfile)exEntity.get();
                if (exProfile.getUserAttribute() != null) {
                    this.userAttributeRepository.deleteAll((Iterable)exProfile.getUserAttribute());
                }
                if (exProfile.getUserRole() != null) {
                    this.roleRepository.deleteAll((Iterable)exProfile.getUserRole());
                }
                this.repository.save((Object)entity);
                return request.getProfile();
            }
            LOGGER.error("Cannot find a user profile for " + userId);
            throw new EntityNotFoundException("Cannot find a user profile for " + userId);
        }
        catch (Exception ex) {
            String msg = "Error occurred while updating user profile for " + request.getProfile().getUsername() + "at " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.user.profile.api.UserProfile getUserProfile(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getUserProfile for " + request.getProfile().getUsername() + "at " + request.getTenantId());
            String userId = request.getProfile().getUsername() + "@" + request.getTenantId();
            Optional entity = this.repository.findById((Object)userId);
            if (entity.isPresent()) {
                UserProfile profileEntity = (UserProfile)entity.get();
                return UserProfileMapper.createUserProfileFromUserProfileEntity((UserProfile)profileEntity, null);
            }
            return null;
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching user profile for " + request.getProfile().getUsername() + "at " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.user.profile.api.UserProfile deleteUserProfile(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to deleteUserProfile for " + request.getProfile().getUsername() + "at " + request.getTenantId());
            long tenantId = request.getTenantId();
            String username = request.getProfile().getUsername();
            String userId = username + "@" + tenantId;
            Optional profileEntity = this.repository.findById((Object)userId);
            if (profileEntity.isPresent()) {
                UserProfile entity = (UserProfile)profileEntity.get();
                org.apache.custos.core.user.profile.api.UserProfile profile = UserProfileMapper.createUserProfileFromUserProfileEntity((UserProfile)entity, null);
                this.repository.delete((Object)entity);
                return profile;
            }
            throw new EntityNotFoundException("Could not find the UserProfile with the id: " + userId);
        }
        catch (Exception ex) {
            String msg = "Error occurred while deleting user profile for " + request.getProfile().getUsername() + "at " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public GetAllUserProfilesResponse getAllUserProfilesInTenant(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getAllUserProfilesInTenant for " + request.getTenantId());
            long tenantId = request.getTenantId();
            int limit = request.getLimit();
            int offset = request.getOffset();
            List profileList = limit > 0 ? this.repository.findByTenantIdWithPagination(tenantId, (long)limit, (long)offset) : this.repository.findByTenantId(tenantId);
            List<org.apache.custos.core.user.profile.api.UserProfile> userProfileList = null;
            if (profileList != null && !profileList.isEmpty()) {
                userProfileList = profileList.stream().map(entity -> UserProfileMapper.createUserProfileFromUserProfileEntity((UserProfile)entity, null)).toList();
            }
            return GetAllUserProfilesResponse.newBuilder().addAllProfiles(userProfileList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching  user profile for tenant " + request.getTenantId();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public GetAllUserProfilesResponse findUserProfilesByAttributes(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to findUserProfilesByAttributes at " + request.getTenantId());
            List attributeList = request.getProfile().getAttributesList();
            ArrayList selectedProfiles = new ArrayList();
            ArrayList userProfileList = new ArrayList();
            attributeList.forEach(atr -> {
                ProtocolStringList values = atr.getValuesList();
                values.forEach(val -> {
                    List userAttributes = this.userAttributeRepository.findFilteredUserProfiles(atr.getKey(), val);
                    if (userAttributes == null || userAttributes.isEmpty()) {
                        return;
                    }
                    if (selectedProfiles.isEmpty()) {
                        selectedProfiles.addAll(userAttributes);
                    } else {
                        List<UserProfile> profiles = userAttributes.stream().filter(newProf -> {
                            AtomicBoolean matched = new AtomicBoolean(false);
                            selectedProfiles.forEach(selectedProfile -> {
                                if (selectedProfile.getId().equals(newProf.getId())) {
                                    matched.set(true);
                                }
                            });
                            return matched.get();
                        }).toList();
                        selectedProfiles.clear();
                        selectedProfiles.addAll(profiles);
                    }
                });
            });
            if (!selectedProfiles.isEmpty()) {
                selectedProfiles.forEach(userProfile -> {
                    org.apache.custos.core.user.profile.api.UserProfile prof = UserProfileMapper.createUserProfileFromUserProfileEntity((UserProfile)userProfile, null);
                    userProfileList.add(prof);
                });
                return GetAllUserProfilesResponse.newBuilder().addAllProfiles(userProfileList).build();
            }
            return GetAllUserProfilesResponse.newBuilder().build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching user profile for " + request.getProfile().getUsername() + "at " + request.getTenantId();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetUpdateAuditTrailResponse getUserProfileAuditTrails(GetUpdateAuditTrailRequest request) {
        try {
            LOGGER.debug("Request received to getUserProfileAuditTrails for " + request.getUsername() + "at " + request.getTenantId());
            String username = request.getUsername();
            long tenantId = request.getTenantId();
            String userId = username + "@" + tenantId;
            List statusUpdateMetadata = this.statusUpdaterRepository.findAllByUserProfileId(userId);
            List attributeUpdateMetadata = this.attributeUpdateMetadataRepository.findAllByUserProfileId(userId);
            List<UserProfileStatusUpdateMetadata> userProfileStatusUpdateMetadata = null;
            List<UserProfileAttributeUpdateMetadata> userProfileAttributeUpdateMetadata = null;
            if (statusUpdateMetadata != null && !statusUpdateMetadata.isEmpty()) {
                userProfileStatusUpdateMetadata = statusUpdateMetadata.stream().map(StatusUpdateMetadataMapper::createUserProfileStatusMetadataFrom).toList();
            }
            if (attributeUpdateMetadata != null && !attributeUpdateMetadata.isEmpty()) {
                userProfileAttributeUpdateMetadata = attributeUpdateMetadata.stream().map(AttributeUpdateMetadataMapper::createAttributeUpdateMetadataFromEntity).toList();
            }
            return GetUpdateAuditTrailResponse.newBuilder().addAllAttributeAudit(userProfileAttributeUpdateMetadata).addAllStatusAudit(userProfileStatusUpdateMetadata).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching  audit trials " + request.getUsername() + "at " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.user.profile.api.Group createGroup(GroupRequest request) {
        try {
            Optional exOP;
            LOGGER.debug("Request received to createGroup from tenant" + request.getTenantId());
            String groupId = request.getGroup().getId();
            long tenantId = request.getTenantId();
            String effectiveId = groupId + "@" + tenantId;
            Optional op = this.groupRepository.findById((Object)effectiveId);
            String ownerId = request.getGroup().getOwnerId() + "@" + tenantId;
            Optional userProfile = this.repository.findById((Object)ownerId);
            if (userProfile.isEmpty()) {
                String msg = "Error occurred while creating  Group for " + request.getTenantId() + " reason : Owner  not found";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            Group savedGroup = null;
            if (op.isEmpty()) {
                Group entity = GroupMapper.createGroupEntity((org.apache.custos.core.user.profile.api.Group)request.getGroup(), (long)request.getTenantId());
                String parentId = entity.getParentId();
                if (parentId != null && !parentId.trim().isEmpty()) {
                    Optional parent = this.groupRepository.findById((Object)parentId);
                    if (parent.isEmpty()) {
                        String msg = "Error occurred while creating  Group for " + request.getTenantId() + " reason : Parent group not found";
                        LOGGER.error(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    GroupMapper.setParentGroupMembership((Group)((Group)parent.get()), (Group)entity);
                }
                savedGroup = (Group)this.groupRepository.save((Object)entity);
            }
            if ((exOP = this.groupRepository.findById((Object)effectiveId)).isPresent()) {
                UserGroupMembershipType exist;
                String type = DefaultGroupMembershipTypes.OWNER.name();
                Optional groupMembershipType = this.groupMembershipTypeRepository.findById((Object)type);
                if (groupMembershipType.isEmpty()) {
                    exist = new UserGroupMembershipType();
                    exist.setId(type);
                    this.groupMembershipTypeRepository.save((Object)exist);
                } else {
                    exist = (UserGroupMembershipType)groupMembershipType.get();
                }
                UserGroupMembership userGroupMembership = new UserGroupMembership();
                userGroupMembership.setGroup(savedGroup);
                userGroupMembership.setUserProfile((UserProfile)userProfile.get());
                userGroupMembership.setTenantId(Long.valueOf(tenantId));
                userGroupMembership.setUserGroupMembershipType(exist);
                this.groupMembershipRepository.save((Object)userGroupMembership);
                return GroupMapper.createGroup((Group)((Group)exOP.get()), (String)userGroupMembership.getUserProfile().getUsername());
            }
            String msg = MessageFormat.format("Error occurred while creating the Group: {0} for the Tenant: {1}", effectiveId, request.getTenantId());
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while creating Group for " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.user.profile.api.Group updateGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to updateGroup for group with id  " + request.getGroup().getId() + " at tenant " + request.getTenantId());
            String groupId = request.getGroup().getId();
            long tenantId = request.getTenantId();
            String effectiveId = groupId + "@" + tenantId;
            Optional exEntity = this.groupRepository.findById((Object)effectiveId);
            if (exEntity.isPresent()) {
                Group entity = GroupMapper.createGroupEntity((org.apache.custos.core.user.profile.api.Group)request.getGroup(), (long)request.getTenantId());
                entity.setCreatedAt(((Group)exEntity.get()).getCreatedAt());
                Group exGroup = (Group)exEntity.get();
                if (exGroup.getGroupAttribute() != null) {
                    this.groupAttributeRepository.deleteAll((Iterable)exGroup.getGroupAttribute());
                }
                if (exGroup.getGroupRole() != null) {
                    this.groupRoleRepository.deleteAll((Iterable)exGroup.getGroupRole());
                }
                this.groupRepository.save((Object)entity);
                Optional exOP = this.groupRepository.findById((Object)effectiveId);
                if (exOP.isPresent()) {
                    List userGroupMemberships = this.groupMembershipRepository.findAllByGroupId(effectiveId);
                    String ownerId = null;
                    for (UserGroupMembership userGroupMembership : userGroupMemberships) {
                        if (!userGroupMembership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())) continue;
                        ownerId = userGroupMembership.getUserProfile().getUsername();
                    }
                    return GroupMapper.createGroup((Group)((Group)exOP.get()), ownerId);
                }
                String msg = "Error occurred while updating group  " + request.getTenantId() + " reason : DB error";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            String msg = "Cannot find a group for " + groupId;
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while updating group " + request.getGroup().getId() + "at " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public void deleteGroup(GroupRequest request) {
        block4: {
            try {
                LOGGER.debug("Request received to deleteGroup for " + request.getGroup().getId() + "at " + request.getTenantId());
                String userId = request.getGroup().getId();
                long tenantId = request.getTenantId();
                String effectiveId = userId + "@" + tenantId;
                Optional op = this.groupRepository.findById((Object)effectiveId);
                if (op.isPresent()) {
                    Group entity = (Group)op.get();
                    List userGroupMemberships = this.groupMembershipRepository.findAllByGroupId(effectiveId);
                    String ownerId = userGroupMemberships.stream().filter(u -> u.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())).map(u -> u.getUserProfile().getUsername()).findAny().orElse(null);
                    org.apache.custos.core.user.profile.api.Group prof = GroupMapper.createGroup((Group)entity, (String)ownerId);
                    this.groupRepository.delete((Object)((Group)op.get()));
                    List groupList = this.groupRepository.findByParentId(entity.getId());
                    if (groupList != null && !groupList.isEmpty()) {
                        this.groupRepository.deleteAll((Iterable)groupList);
                    }
                    break block4;
                }
                String msg = "Cannot find a group for " + request.getId();
                LOGGER.error(msg);
                throw new EntityNotFoundException(msg);
            }
            catch (Exception ex) {
                String msg = "Error occurred while deleting group for " + String.valueOf(request.getGroup()) + "at " + request.getTenantId() + " reason :" + ex.getMessage();
                LOGGER.error(msg, (Throwable)ex);
            }
        }
    }

    public org.apache.custos.core.user.profile.api.Group getGroup(GroupRequest request) {
        LOGGER.debug("Request received to getGroup for group " + request.getGroup().getId() + "at " + request.getTenantId());
        String userId = request.getGroup().getId();
        long tenantId = request.getTenantId();
        String effectiveId = userId + "@" + tenantId;
        Optional op = this.groupRepository.findById((Object)effectiveId);
        if (op.isPresent()) {
            List userGroupMemberships = this.groupMembershipRepository.findAllByGroupId(effectiveId);
            String ownerId = userGroupMemberships.stream().filter(userGroupMembership -> userGroupMembership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())).map(userGroupMembership -> userGroupMembership.getUserProfile().getUsername()).findFirst().orElse(null);
            return GroupMapper.createGroup((Group)((Group)op.get()), (String)ownerId);
        }
        LOGGER.error("Could not find the Group with the Id: " + request.getGroup().getId());
        throw new EntityNotFoundException("Could not find the Group with the Id: " + request.getGroup().getId());
    }

    public GetAllGroupsResponse getAllGroups(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroups for " + request.getTenantId());
            List groups = this.groupRepository.searchEntities(request.getTenantId(), request.getGroup(), request.getOffset(), request.getLimit());
            if (groups == null || groups.isEmpty()) {
                groups = this.groupRepository.findAllByTenantId(request.getTenantId());
            }
            ArrayList<org.apache.custos.core.user.profile.api.Group> groupList = new ArrayList<org.apache.custos.core.user.profile.api.Group>();
            if (groups != null && !groups.isEmpty()) {
                for (Group group : groups) {
                    List userGroupMemberships = this.groupMembershipRepository.findAllByGroupId(group.getId());
                    String ownerId = null;
                    Optional<UserGroupMembership> ownerOptional = userGroupMemberships.stream().filter(userGroupMembership -> userGroupMembership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())).findFirst();
                    if (ownerOptional.isPresent()) {
                        ownerId = ownerOptional.get().getUserProfile().getUsername();
                    }
                    org.apache.custos.core.user.profile.api.Group gr = GroupMapper.createGroup((Group)group, ownerId);
                    groupList.add(gr);
                }
            }
            return GetAllGroupsResponse.newBuilder().addAllGroups(groupList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching groups of client " + request.getClientId() + " reason :" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public Status addUserToGroup(GroupMembership request) {
        try {
            LOGGER.debug("Request received to addUserToGroup for " + request.getTenantId());
            String group_id = request.getGroupId();
            String username = request.getUsername();
            long tenantId = request.getTenantId();
            String userId = username + "@" + tenantId;
            String effectiveGroupId = group_id + "@" + tenantId;
            Optional group = this.groupRepository.findById((Object)effectiveGroupId);
            Optional userProfile = this.repository.findById((Object)userId);
            if (group.isPresent() && userProfile.isPresent()) {
                List memberships = this.groupMembershipRepository.findAllByGroupIdAndUserProfileId(effectiveGroupId, userId);
                if (memberships == null || memberships.isEmpty()) {
                    UserGroupMembershipType exist;
                    String type = request.getType();
                    type = type.isBlank() ? DefaultGroupMembershipTypes.MEMBER.name() : type.toUpperCase();
                    Optional groupMembershipType = this.groupMembershipTypeRepository.findById((Object)type);
                    if (groupMembershipType.isEmpty()) {
                        exist = new UserGroupMembershipType();
                        exist.setId(type);
                        this.groupMembershipTypeRepository.save((Object)exist);
                    } else {
                        exist = (UserGroupMembershipType)groupMembershipType.get();
                    }
                    UserGroupMembership userGroupMembership = new UserGroupMembership();
                    userGroupMembership.setGroup((Group)group.get());
                    userGroupMembership.setUserProfile((UserProfile)userProfile.get());
                    userGroupMembership.setTenantId(Long.valueOf(tenantId));
                    userGroupMembership.setUserGroupMembershipType(exist);
                    this.groupMembershipRepository.save((Object)userGroupMembership);
                }
                return Status.newBuilder().setStatus(true).build();
            }
            String msg = "Group or user not available";
            LOGGER.error(msg);
            throw new EntityNotFoundException("Group or user not available");
        }
        catch (Exception ex) {
            String msg = "Error occurred while add user to  group at  " + request.getTenantId() + " reason :" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public Status removeUserFromGroup(GroupMembership request) {
        try {
            LOGGER.debug("Request received to removeUserFromGroup for " + request.getTenantId());
            String group_id = request.getGroupId();
            String username = request.getUsername();
            long tenantId = request.getTenantId();
            String userId = username + "@" + tenantId;
            String effectiveGroupId = group_id + "@" + tenantId;
            List memberships = this.groupMembershipRepository.findAllByGroupIdAndUserProfileId(effectiveGroupId, userId);
            List userGroupMemberships = this.groupMembershipRepository.findAllByGroupIdAndUserGroupMembershipTypeId(effectiveGroupId, DefaultGroupMembershipTypes.OWNER.name());
            if (userGroupMemberships != null && userGroupMemberships.size() == 1 && ((UserGroupMembership)userGroupMemberships.get(0)).getUserProfile().getUsername().equals(username)) {
                String msg = "Default owner " + username + " cannot be removed from group " + group_id;
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (memberships != null && !memberships.isEmpty()) {
                this.groupMembershipRepository.deleteAll((Iterable)memberships);
            }
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while removing user from  in client " + request.getClientId() + " reason :" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public Status addChildGroupToParentGroup(GroupToGroupMembership request) {
        try {
            org.apache.custos.core.model.user.GroupToGroupMembership membership;
            org.apache.custos.core.model.user.GroupToGroupMembership saved;
            LOGGER.debug("Request received to addChildGroupToParentGroup for " + request.getTenantId());
            long tenantId = request.getTenantId();
            String childId = request.getChildId();
            String parentId = request.getParentId();
            String effectiveChildId = childId + "@" + tenantId;
            String effectiveParentId = parentId + "@" + tenantId;
            Optional childEntity = this.groupRepository.findById((Object)effectiveChildId);
            Optional parentEntity = this.groupRepository.findById((Object)effectiveParentId);
            if (childEntity.isEmpty() || parentEntity.isEmpty()) {
                String msg = "Child or parent group not available";
                LOGGER.error(msg);
                throw new NotFoundException(msg);
            }
            List groupToGroupMemberships = this.groupToGroupMembershipRepository.findByChildIdAndParentId(effectiveChildId, effectiveParentId);
            if ((groupToGroupMemberships == null || groupToGroupMemberships.isEmpty()) && (saved = (org.apache.custos.core.model.user.GroupToGroupMembership)this.groupToGroupMembershipRepository.save((Object)(membership = GroupMapper.groupToGroupMembership((Group)((Group)childEntity.get()), (Group)((Group)parentEntity.get()))))).getId() != null) {
                ((Group)childEntity.get()).setParentId(parentId);
                this.groupRepository.save((Object)((Group)childEntity.get()));
                return Status.newBuilder().setStatus(true).build();
            }
            String msg = "Group membership creation failed";
            LOGGER.error(msg);
            throw new InternalServerException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred while adding child group to parent group for " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg);
        }
    }

    public Status removeChildGroupFromParentGroup(GroupToGroupMembership request) {
        try {
            LOGGER.debug("Request received to removeChildGroupFromParentGroup for " + request.getTenantId());
            long tenantId = request.getTenantId();
            String childId = request.getChildId();
            String parentId = request.getParentId();
            String effectiveChildId = childId + "@" + tenantId;
            String effectiveParentId = parentId + "@" + tenantId;
            Optional childEntity = this.groupRepository.findById((Object)effectiveChildId);
            Optional parentEntity = this.groupRepository.findById((Object)effectiveParentId);
            if (childEntity.isEmpty() || parentEntity.isEmpty()) {
                String msg = "Child or parent group not available";
                LOGGER.error(msg);
                throw new NotFoundException(msg);
            }
            List groupToGroupMemberships = this.groupToGroupMembershipRepository.findByChildIdAndParentId(effectiveChildId, effectiveParentId);
            if (groupToGroupMemberships != null && !groupToGroupMemberships.isEmpty()) {
                this.groupToGroupMembershipRepository.delete((Object)((org.apache.custos.core.model.user.GroupToGroupMembership)groupToGroupMemberships.get(0)));
            }
            ((Group)childEntity.get()).setParentId("");
            this.groupRepository.save((Object)((Group)childEntity.get()));
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while remove child group from parent group for " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg);
        }
    }

    public GetAllGroupsResponse getAllParentGroupsOfGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllParentGroupsOfGroup for " + request.getTenantId());
            String groupId = request.getGroup().getId();
            long tenantId = request.getTenantId();
            String effectiveId = groupId + "@" + tenantId;
            Optional groups = this.groupRepository.findById((Object)effectiveId);
            if (groups.isEmpty()) {
                return GetAllGroupsResponse.newBuilder().build();
            }
            ArrayList<Group> groupList = new ArrayList<Group>();
            groupList.add((Group)groups.get());
            Map<String, Group> groupMap = this.getAllUniqueGroups(groupList, null);
            ArrayList serviceGroupList = new ArrayList();
            groupMap.keySet().forEach(gr -> {
                List userGroupMemberships = this.groupMembershipRepository.findAllByGroupId(effectiveId);
                String ownerId = null;
                for (UserGroupMembership userGroupMembership : userGroupMemberships) {
                    if (!userGroupMembership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())) continue;
                    ownerId = userGroupMembership.getUserProfile().getUsername();
                }
                serviceGroupList.add(GroupMapper.createGroup((Group)((Group)groupMap.get(gr)), ownerId));
            });
            return GetAllGroupsResponse.newBuilder().addAllGroups(serviceGroupList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching all parent groups for group " + request.getGroup().getId() + " in tenant " + request.getTenantId() + " reason :" + ex.getMessage();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllGroupsResponse getAllGroupsOfUser(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroupsOfUser for " + request.getTenantId());
            long tenantId = request.getTenantId();
            String username = request.getProfile().getUsername();
            String userId = username + "@" + tenantId;
            List userGroupMemberships = this.groupMembershipRepository.findAllByUserProfileId(userId);
            ArrayList<Group> groups = new ArrayList<Group>();
            if (userGroupMemberships != null && !userGroupMemberships.isEmpty()) {
                userGroupMemberships.forEach(userGroupMembership -> {
                    AtomicBoolean toBeAdded = new AtomicBoolean(true);
                    groups.forEach(le -> {
                        if (le.getId().equals(userGroupMembership.getGroup().getId())) {
                            toBeAdded.set(false);
                        }
                    });
                    if (toBeAdded.get()) {
                        groups.add(userGroupMembership.getGroup());
                    }
                });
            }
            Map<String, Group> groupMap = this.getAllUniqueGroups(groups, null);
            ArrayList groupList = new ArrayList();
            groupMap.keySet().forEach(gr -> {
                List memberships = this.groupMembershipRepository.findAllByGroupId(gr);
                String ownerId = null;
                for (UserGroupMembership userGroupMembership : memberships) {
                    if (!userGroupMembership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())) continue;
                    ownerId = userGroupMembership.getUserProfile().getUsername();
                    break;
                }
                int totalMembers = this.groupMembershipRepository.countByGroupId(gr);
                String requesterRole = ((UserGroupMembership)this.groupMembershipRepository.findFirstByGroupIdAndUserProfileId(gr, userId).orElseThrow()).getUserGroupMembershipType().getId();
                groupList.add(GroupMapper.createGroup((Group)((Group)groupMap.get(gr)), (String)ownerId, (int)totalMembers, (String)requesterRole));
            });
            return GetAllGroupsResponse.newBuilder().addAllGroups(groupList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching user groups of user " + request.getProfile().getUsername() + " in tenant " + request.getTenantId() + " reason :" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public Status addUserGroupMembershipType(UserGroupMembershipTypeRequest request) {
        try {
            LOGGER.debug("Request received to addUserGroupMembershipType of type  " + request.getType());
            String type = request.getType().toUpperCase();
            Optional userGroupMembershipType = this.groupMembershipTypeRepository.findById((Object)type);
            if (userGroupMembershipType.isEmpty()) {
                UserGroupMembershipType userGroupType = new UserGroupMembershipType();
                userGroupType.setId(type);
                this.groupMembershipTypeRepository.save((Object)userGroupType);
            }
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while saving group membership type" + request.getType();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public Status removeUserGroupMembershipType(UserGroupMembershipTypeRequest request) {
        try {
            LOGGER.debug("Request received to removeUserGroupMembershipType of type " + request.getType());
            String type = request.getType().toUpperCase();
            Optional userGroupMembershipType = this.groupMembershipTypeRepository.findById((Object)type);
            userGroupMembershipType.ifPresent(groupMembershipType -> this.groupMembershipTypeRepository.delete(groupMembershipType));
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while deleting removeUserGroupMembershipType of type  " + request.getType();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public GetAllUserProfilesResponse getAllChildUsers(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllChildUsers in tenant " + request.getTenantId() + " for group with Id " + request.getGroup().getId());
            long tenantId = request.getTenantId();
            String username = request.getGroup().getId();
            String effectiveId = username + "@" + tenantId;
            Optional groupOptional = this.groupRepository.findById((Object)effectiveId);
            if (groupOptional.isEmpty()) {
                String msg = "group not found: " + request.getGroup().getId();
                LOGGER.error(msg);
                throw new NotFoundException(msg);
            }
            List memberships = this.groupMembershipRepository.findAllByGroupId(effectiveId);
            ArrayList userProfileList = new ArrayList();
            ArrayList selectedProfiles = new ArrayList();
            if (memberships != null && !memberships.isEmpty()) {
                memberships.forEach(mem -> {
                    AtomicBoolean addToList = new AtomicBoolean(true);
                    selectedProfiles.forEach(ex -> {
                        if (String.valueOf(ex.getId()).equals(mem.getUserProfile().getId())) {
                            addToList.set(false);
                        }
                    });
                    if (addToList.get()) {
                        selectedProfiles.add(mem);
                    }
                });
            }
            if (!selectedProfiles.isEmpty()) {
                selectedProfiles.forEach(gr -> userProfileList.add(UserProfileMapper.createUserProfileFromUserProfileEntity((UserProfile)gr.getUserProfile(), (String)gr.getUserGroupMembershipType().getId())));
            }
            return GetAllUserProfilesResponse.newBuilder().addAllProfiles(userProfileList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching all child users in tenant " + request.getTenantId() + " for group with Id " + request.getGroup().getId();
            LOGGER.error(msg);
            throw new InternalServerException(msg, ex);
        }
    }

    public GetAllGroupsResponse getAllChildGroups(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllChildGroups in tenant " + request.getTenantId() + " for group with Id " + request.getGroup().getId());
            long tenantId = request.getTenantId();
            String groupId = request.getGroup().getId();
            String effectiveParentId = groupId + "@" + tenantId;
            Optional groupOptional = this.groupRepository.findById((Object)effectiveParentId);
            if (groupOptional.isEmpty()) {
                String msg = "group not found: " + request.getGroup().getId();
                LOGGER.error(msg);
                throw new NotFoundException(msg);
            }
            List memberships = this.groupToGroupMembershipRepository.findAllByParentId(effectiveParentId);
            ArrayList groupList = new ArrayList();
            HashMap selectedGroupMap = new HashMap();
            if (memberships != null && !memberships.isEmpty()) {
                memberships.forEach(mem -> selectedGroupMap.put(mem.getChild().getId(), mem.getChild()));
            }
            selectedGroupMap.values().forEach(group -> {
                List groupMemberships = this.groupMembershipRepository.findAllByGroupId(group.getId());
                AtomicReference ownerId = new AtomicReference();
                groupMemberships.forEach(grm -> {
                    if (grm.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name())) {
                        ownerId.set(grm.getUserProfile().getUsername());
                    }
                });
                groupList.add(GroupMapper.createGroup((Group)group, (String)((String)ownerId.get())));
            });
            return GetAllGroupsResponse.newBuilder().addAllGroups(groupList).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while fetching all child groups in tenant " + request.getTenantId() + " for group with Id " + request.getGroup().getId();
            LOGGER.error(msg, (Throwable)ex);
            throw new InternalServerException(msg, ex);
        }
    }

    public Status changeUserMembershipType(GroupMembership request) {
        try {
            List memberships;
            LOGGER.debug("Request received to changeUserMembershipType in   tenant" + request.getTenantId() + " with id " + request.getUsername() + " to " + request.getType());
            long tenantId = request.getTenantId();
            String username = request.getUsername();
            String groupId = request.getGroupId();
            String type = request.getType();
            String userId = username + "@" + tenantId;
            String effectiveGroupId = groupId + "@" + tenantId;
            List userGroupMemberships = this.groupMembershipRepository.findAllByGroupIdAndUserProfileId(effectiveGroupId, userId);
            if (userGroupMemberships == null || userGroupMemberships.isEmpty()) {
                String msg = "group membership not found";
                LOGGER.error(msg);
                throw new EntityNotFoundException(msg);
            }
            List userMemberships = this.groupMembershipRepository.findAllByGroupIdAndUserGroupMembershipTypeId(effectiveGroupId, DefaultGroupMembershipTypes.OWNER.name());
            if (userMemberships != null && userMemberships.size() == 1 && ((UserGroupMembership)userMemberships.get(0)).getUserProfile().getUsername().equals(username)) {
                String msg = "Default owner " + username + " cannot be changed for group " + groupId;
                LOGGER.error(msg);
                throw new IllegalArgumentException(msg);
            }
            UserGroupMembership groupMembership = (UserGroupMembership)userGroupMemberships.get(0);
            UserGroupMembershipType groupMembershipType = groupMembership.getUserGroupMembershipType();
            groupMembershipType.setId(type);
            groupMembership.setUserGroupMembershipType(groupMembershipType);
            this.groupMembershipRepository.save((Object)groupMembership);
            if (type.equals(DefaultGroupMembershipTypes.OWNER.name()) && (memberships = this.groupMembershipRepository.findAllByGroupId(effectiveGroupId)) != null && !memberships.isEmpty()) {
                for (UserGroupMembership membership : memberships) {
                    if (!membership.getUserGroupMembershipType().getId().equals(DefaultGroupMembershipTypes.OWNER.name()) || membership.getUserProfile().getUsername().equals(userId)) continue;
                    this.groupMembershipRepository.delete((Object)membership);
                    UserGroupMembership userGroupMembership = new UserGroupMembership();
                    userGroupMembership.setGroup(membership.getGroup());
                    userGroupMembership.setUserProfile(membership.getUserProfile());
                    userGroupMembership.setTenantId(Long.valueOf(tenantId));
                    Optional membershipType = this.groupMembershipTypeRepository.findById((Object)DefaultGroupMembershipTypes.MEMBER.name());
                    userGroupMembership.setUserGroupMembershipType((UserGroupMembershipType)membershipType.get());
                    this.groupMembershipRepository.save((Object)userGroupMembership);
                }
            }
            return Status.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while changing membership type  in   tenant" + request.getTenantId() + " with id " + request.getUsername() + " to " + request.getType();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public Status hasAccess(GroupMembership request) {
        try {
            LOGGER.debug("Request received to check access  in   tenant" + request.getTenantId() + " with id " + request.getUsername() + " to " + request.getType());
            long tenantId = request.getTenantId();
            String username = request.getUsername();
            String groupId = request.getGroupId();
            String type = request.getType();
            String userId = username + "@" + tenantId;
            String effectiveGroupId = groupId + "@" + tenantId;
            List userGroupMemberships = this.groupMembershipRepository.findAllByGroupIdAndUserProfileIdAndUserGroupMembershipTypeId(effectiveGroupId, userId, type);
            return Status.newBuilder().setStatus(userGroupMemberships != null && !userGroupMemberships.isEmpty()).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while checking access to   in   tenant" + request.getTenantId() + " with id " + request.getUsername() + " to " + request.getType();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public List<Group> getGroupsOfUser(UserProfileRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroupsOfUser for " + request.getTenantId());
            long tenantId = request.getTenantId();
            String username = request.getProfile().getUsername();
            String userId = username + "@" + tenantId;
            List userGroupMemberships = this.groupMembershipRepository.findAllByUserProfileId(userId);
            return userGroupMemberships.stream().map(UserGroupMembership::getGroup).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    private Map<String, Group> getAllUniqueGroups(List<Group> leaveGroups, Map<String, Group> allParentGroups) {
        if (allParentGroups == null) {
            allParentGroups = new HashMap<String, Group>();
        }
        if (leaveGroups != null && !leaveGroups.isEmpty()) {
            for (Group gr : leaveGroups) {
                List memberships = this.groupToGroupMembershipRepository.findAllByChildId(gr.getId());
                ArrayList<Group> leaves = new ArrayList<Group>();
                allParentGroups.put(gr.getId(), gr);
                if (memberships == null || memberships.isEmpty()) continue;
                memberships.forEach(mem -> {
                    AtomicBoolean toBeAdded = new AtomicBoolean(true);
                    leaves.forEach(le -> {
                        if (le.getId().equals(mem.getParent().getId())) {
                            toBeAdded.set(false);
                        }
                    });
                    if (toBeAdded.get()) {
                        leaves.add(mem.getParent());
                    }
                });
                this.getAllUniqueGroups(leaves, allParentGroups);
            }
        }
        return allParentGroups;
    }
}

