/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;
import org.hibernate.internal.util.NullnessUtil;

public class AtomikosJtaPlatform
extends AbstractJtaPlatform {
    public static final @UnknownKeyFor @NonNull @Initialized String TM_CLASS_NAME = "com.atomikos.icatch.jta.UserTransactionManager";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        try {
            Class transactionManagerClass = NullnessUtil.castNonNull(this.serviceRegistry().getService(ClassLoaderService.class)).classForName(TM_CLASS_NAME);
            return (TransactionManager)transactionManagerClass.newInstance();
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not instantiate Atomikos TransactionManager", e);
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        return (UserTransaction)this.jndiService().locate("java:comp/UserTransaction");
    }
}

