/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.helper;

import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    File artemisHome;
    File artemisInstance;
    String[] args = new String[0];

    HelperBase(String homeProperty) {
        this.setArtemisHome(HelperBase.getHome(homeProperty));
        logger.debug("using artemisHome as {}", (Object)this.artemisHome);
    }

    HelperBase(File artemisHome) {
        this.setArtemisHome(artemisHome);
        logger.debug("using artemisHome as {}", (Object)artemisHome);
    }

    public static File getHome(String homeProperty) {
        String valueHome = System.getProperty(homeProperty);
        if (valueHome == null) {
            throw new IllegalArgumentException("System property " + valueHome + " not defined");
        }
        return new File(valueHome);
    }

    public File getArtemisHome() {
        return this.artemisHome;
    }

    public HelperBase setArtemisHome(File artemisHome) {
        this.artemisHome = artemisHome;
        if (!artemisHome.exists()) {
            throw new IllegalArgumentException(String.valueOf(artemisHome) + " folder does not exist in the file system");
        }
        if (!new File(artemisHome, "/bin").exists() || !new File(artemisHome, "/bin/artemis").exists()) {
            throw new IllegalArgumentException("invalid bin folder");
        }
        return this;
    }

    public File getArtemisInstance() {
        return this.artemisInstance;
    }

    public HelperBase setArtemisInstance(File artemisInstance) {
        this.artemisInstance = artemisInstance;
        return this;
    }

    public String[] getArgs() {
        return this.args;
    }

    public HelperBase setArgs(String ... args) {
        this.args = args;
        return this;
    }

    public HelperBase addArgs(String ... args) {
        int i;
        int initialLength = this.args == null ? 0 : this.args.length;
        String[] newArgs = new String[initialLength + args.length];
        for (i = 0; i < initialLength; ++i) {
            newArgs[i] = this.args[i];
        }
        for (i = 0; i < args.length; ++i) {
            newArgs[i + initialLength] = args[i];
        }
        this.args = newArgs;
        return this;
    }
}

