/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemoteAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPFederationAddressSenderController
extends AMQPFederationSenderController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AMQPFederationAddressSenderController(AMQPFederationRemoteAddressPolicyManager manager, AMQPFederationMetrics.ProducerMetrics metrics, Consumer<AMQPFederationSenderController> closedListener) throws ActiveMQAMQPException {
        super(manager, metrics, closedListener);
    }

    @Override
    public AMQPFederationSenderController.Role getRole() {
        return AMQPFederationSenderController.Role.ADDRESS_PRODUCER;
    }

    @Override
    public ServerConsumer createServerConsumer(ProtonServerSenderContext senderContext) throws Exception {
        AddressQueryResult addressQueryResult;
        SimpleString queueName;
        SimpleString address;
        Object selector;
        Sender sender = senderContext.getSender();
        Source source = (Source)sender.getRemoteSource();
        SimpleString sourceAddress = SimpleString.of((String)source.getAddress());
        Connection protonConnection = this.session.getSession().getConnection();
        sender.setSenderSettleMode(sender.getRemoteSenderSettleMode());
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        sender.setOfferedCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER});
        sender.setDesiredCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
        Map addressSourceProperties = sender.getRemoteProperties() == null || !sender.getRemoteProperties().containsKey(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES) ? Collections.emptyMap() : (Map)sender.getRemoteProperties().get(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES);
        boolean autoDelete = addressSourceProperties.getOrDefault("auto-delete", false);
        long autoDeleteDelay = ((Number)addressSourceProperties.getOrDefault("auto-delete-delay", 0)).longValue();
        long autoDeleteMsgCount = ((Number)addressSourceProperties.getOrDefault("auto-delete-msg-count", 0)).longValue();
        String jmsSelector = this.getJMSSelectorFromFilters(source);
        Map.Entry<Symbol, DescribedType> noLocal = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS);
        if (noLocal != null) {
            String remoteContainerId = protonConnection.getRemoteContainer();
            String noLocalFilter = "__AMQ_CID<>'" + remoteContainerId + "'";
            selector = jmsSelector == null ? noLocalFilter : jmsSelector + " AND " + noLocalFilter;
        } else {
            selector = jmsSelector;
        }
        if (CompositeAddress.isFullyQualified((SimpleString)sourceAddress)) {
            address = CompositeAddress.extractAddressName((SimpleString)sourceAddress);
            queueName = CompositeAddress.extractQueueName((SimpleString)sourceAddress);
        } else {
            address = sourceAddress;
            queueName = SimpleString.of((String)sender.getName());
        }
        try {
            addressQueryResult = this.sessionSPI.addressQuery(address, RoutingType.MULTICAST, true);
        }
        catch (ActiveMQSecurityException e2) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e2.getMessage());
        }
        catch (ActiveMQAMQPException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new ActiveMQAMQPInternalErrorException(e4.getMessage(), e4);
        }
        if (!addressQueryResult.isExists()) {
            this.federation.registerMissingAddress(address.toString());
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
        }
        Set routingTypes = addressQueryResult.getRoutingTypes();
        if (!routingTypes.contains(RoutingType.MULTICAST)) {
            throw new ActiveMQAMQPIllegalStateException("Address " + String.valueOf(address) + " is not configured for MULTICAST support");
        }
        RoutingType routingType = AMQPFederationAddressSenderController.getRoutingType(source);
        QueueQueryResult queueQuery = this.sessionSPI.queueQuery(queueName, routingType, false);
        if (!queueQuery.isExists()) {
            QueueConfiguration configuration = QueueConfiguration.of((SimpleString)queueName);
            configuration.setAddress(address);
            configuration.setRoutingType(routingType);
            configuration.setAutoCreateAddress(Boolean.valueOf(false));
            configuration.setMaxConsumers(Integer.valueOf(-1));
            configuration.setPurgeOnNoConsumers(Boolean.valueOf(false));
            configuration.setFilterString((String)selector);
            configuration.setDurable(Boolean.valueOf(true));
            configuration.setAutoCreated(Boolean.valueOf(false));
            configuration.setAutoDelete(Boolean.valueOf(autoDelete));
            configuration.setAutoDeleteDelay(Long.valueOf(autoDeleteDelay));
            configuration.setAutoDeleteMessageCount(Long.valueOf(autoDeleteMsgCount));
            queueQuery = this.sessionSPI.queueQuery(configuration, true);
        }
        if (!queueQuery.getAddress().equals((Object)address)) {
            throw new ActiveMQAMQPIllegalStateException("Requested queue: " + String.valueOf(queueName) + " for federation of address: " + String.valueOf(address) + ", but it is already mapped to a different address: " + String.valueOf(queueQuery.getAddress()));
        }
        this.resourceDeletedAction = e -> this.federation.registerMissingAddress(address.toString());
        return this.sessionSPI.createSender(senderContext, queueName, null, false);
    }

    @Override
    protected void handleLinkRemotelyClosed() {
        this.deleteAddressFederationBindingIfPresent();
    }

    @Override
    protected void handleLinkLocallyClosed(ErrorCondition error) {
        if (error != null) {
            this.deleteAddressFederationBindingIfPresent();
        }
    }

    private void deleteAddressFederationBindingIfPresent() {
        if (this.senderContext == null) {
            return;
        }
        try {
            Sender sender = this.senderContext.getSender();
            Source source = (Source)sender.getRemoteSource();
            SimpleString sourceAddress = SimpleString.of((String)source.getAddress());
            RoutingType routingType = AMQPFederationAddressSenderController.getRoutingType(source);
            SimpleString queueName = CompositeAddress.isFullyQualified((SimpleString)sourceAddress) ? CompositeAddress.extractQueueName((SimpleString)sourceAddress) : SimpleString.of((String)sender.getName());
            QueueQueryResult queueQuery = this.sessionSPI.queueQuery(queueName, routingType, false);
            if (queueQuery.isExists()) {
                this.sessionSPI.deleteQueue(queueName);
            }
        }
        catch (Exception e) {
            logger.debug("Federation address sender link closed cleanup caught error: ", (Throwable)e);
        }
    }

    private String getJMSSelectorFromFilters(Source source) throws ActiveMQAMQPException {
        Map.Entry<Symbol, DescribedType> jmsSelector = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS);
        String selectorString = null;
        if (jmsSelector != null) {
            selectorString = jmsSelector.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)selectorString);
            }
            catch (FilterException e) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
        }
        return selectorString;
    }
}

