/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.validator;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Validator;

@Metadata(label="validation")
@XmlType(name="customValidator")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomValidatorDefinition
extends ValidatorDefinition {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String className;

    @Override
    protected Validator doCreateValidator(CamelContext context) throws Exception {
        Validator validator;
        if (this.ref == null && this.className == null) {
            throw new IllegalArgumentException("'ref' or 'type' must be specified for customValidator");
        }
        if (this.ref != null) {
            validator = context.getRegistry().lookupByNameAndType(this.ref, Validator.class);
            if (validator == null) {
                throw new IllegalArgumentException("Cannot find validator with ref:" + this.ref);
            }
            if (validator.getType() != null) {
                throw new IllegalArgumentException(String.format("Validator '%s' is already in use. Please check if duplicate validator exists.", this.ref));
            }
        } else {
            Class<Validator> validatorClass = context.getClassResolver().resolveMandatoryClass(this.className, Validator.class);
            if (validatorClass == null) {
                throw new IllegalArgumentException("Cannot find validator class: " + this.className);
            }
            validator = context.getInjector().newInstance(validatorClass);
        }
        validator.setCamelContext(context);
        return validator.setType(this.getType());
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

