/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.alg.dense.misc.PermuteArray;
import org.ejml.alg.dense.misc.UnrolledDeterminantFromMinor;
import org.ejml.data.DenseMatrix64F;

public class NaiveDeterminant {
    public static double leibniz(DenseMatrix64F denseMatrix64F) {
        PermuteArray permuteArray = new PermuteArray(denseMatrix64F.numCols);
        double d = 0.0;
        int[] nArray = permuteArray.next();
        while (nArray != null) {
            double d2 = 1.0;
            for (int i = 0; i < denseMatrix64F.numRows; ++i) {
                d2 *= denseMatrix64F.get(i, nArray[i]);
            }
            d += (double)permuteArray.sgn() * d2;
            nArray = permuteArray.next();
        }
        return d;
    }

    public static double recursive(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows == 1) {
            return denseMatrix64F.get(0);
        }
        if (denseMatrix64F.numRows == 2) {
            return denseMatrix64F.get(0) * denseMatrix64F.get(3) - denseMatrix64F.get(1) * denseMatrix64F.get(2);
        }
        if (denseMatrix64F.numRows == 3) {
            return UnrolledDeterminantFromMinor.det3(denseMatrix64F);
        }
        double d = 0.0;
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows - 1, denseMatrix64F.numRows - 1);
            for (int j = 1; j < denseMatrix64F.numRows; ++j) {
                for (int k = 0; k < denseMatrix64F.numRows; ++k) {
                    if (k < i) {
                        denseMatrix64F2.set(j - 1, k, denseMatrix64F.get(j, k));
                        continue;
                    }
                    if (k <= i) continue;
                    denseMatrix64F2.set(j - 1, k - 1, denseMatrix64F.get(j, k));
                }
            }
            if (i % 2 == 0) {
                d += denseMatrix64F.get(0, i) * NaiveDeterminant.recursive(denseMatrix64F2);
                continue;
            }
            d -= denseMatrix64F.get(0, i) * NaiveDeterminant.recursive(denseMatrix64F2);
        }
        return d;
    }
}

