/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionHouseholder
implements TridiagonalSimilarDecomposition<DenseMatrix64F> {
    private DenseMatrix64F QT;
    private int N = 1;
    private double[] w = new double[this.N];
    private double[] gammas;
    private double[] b = new double[this.N];

    public TridiagonalDecompositionHouseholder() {
        this.gammas = new double[this.N];
    }

    public DenseMatrix64F getQT() {
        return this.QT;
    }

    @Override
    public void getDiagonal(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.QT.data[i * this.N + i];
            if (i + 1 >= this.N) continue;
            dArray2[i] = this.QT.data[i * this.N + i + 1];
        }
    }

    @Override
    public DenseMatrix64F getT(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            denseMatrix64F.zero();
        }
        denseMatrix64F.data[0] = this.QT.data[0];
        for (int i = 1; i < this.N; ++i) {
            denseMatrix64F.set(i, i, this.QT.get(i, i));
            double d = this.QT.get(i - 1, i);
            denseMatrix64F.set(i - 1, i, d);
            denseMatrix64F.set(i, i - 1, d);
        }
        if (this.N > 1) {
            denseMatrix64F.data[(this.N - 1) * this.N + this.N - 1] = this.QT.data[(this.N - 1) * this.N + this.N - 1];
            denseMatrix64F.data[(this.N - 1) * this.N + this.N - 2] = this.QT.data[(this.N - 2) * this.N + this.N - 1];
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n;
        if (denseMatrix64F == null) {
            denseMatrix64F = CommonOps.identity(this.N);
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (n = 0; n < this.N; ++n) {
            this.w[n] = 0.0;
        }
        if (bl) {
            for (n = this.N - 2; n >= 0; --n) {
                this.w[n + 1] = 1.0;
                for (int i = n + 2; i < this.N; ++i) {
                    this.w[i] = this.QT.data[n * this.N + i];
                }
                QrHelperFunctions.rank1UpdateMultL(denseMatrix64F, this.w, this.gammas[n + 1], n + 1, n + 1, this.N);
            }
        } else {
            for (n = this.N - 2; n >= 0; --n) {
                this.w[n + 1] = 1.0;
                for (int i = n + 2; i < this.N; ++i) {
                    this.w[i] = this.QT.get(n, i);
                }
                QrHelperFunctions.rank1UpdateMultR(denseMatrix64F, this.w, this.gammas[n + 1], n + 1, n + 1, this.N, this.b);
            }
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.init(denseMatrix64F);
        for (int i = 1; i < this.N; ++i) {
            this.similarTransform(i);
        }
        return true;
    }

    private void similarTransform(int n) {
        double[] dArray = this.QT.data;
        double d = 0.0;
        int n2 = (n - 1) * this.N;
        for (int i = n; i < this.N; ++i) {
            double d2 = Math.abs(dArray[n2 + i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            double d3;
            double d4 = QrHelperFunctions.computeTauAndDivide(n, this.N, dArray, n2, d);
            double d5 = dArray[n2 + n] + d4;
            QrHelperFunctions.divideElements(n + 1, this.N, dArray, n2, d5);
            dArray[n2 + n] = 1.0;
            this.gammas[n] = d3 = d5 / d4;
            this.householderSymmetric(n, d3);
            dArray[n2 + n] = -d4 * d;
        } else {
            this.gammas[n] = 0.0;
        }
    }

    public void householderSymmetric(int n, double d) {
        int n2;
        int n3 = (n - 1) * this.N;
        for (int i = n; i < this.N; ++i) {
            int n4;
            double d2 = 0.0;
            for (n4 = n; n4 < i; ++n4) {
                d2 += this.QT.data[n4 * this.N + i] * this.QT.data[n3 + n4];
            }
            for (n4 = i; n4 < this.N; ++n4) {
                d2 += this.QT.data[i * this.N + n4] * this.QT.data[n3 + n4];
            }
            this.w[i] = -d * d2;
        }
        double d3 = 0.0;
        for (n2 = n; n2 < this.N; ++n2) {
            d3 += this.QT.data[n3 + n2] * this.w[n2];
        }
        d3 *= -0.5 * d;
        for (n2 = n; n2 < this.N; ++n2) {
            int n5 = n2;
            this.w[n5] = this.w[n5] + d3 * this.QT.data[n3 + n2];
        }
        for (n2 = n; n2 < this.N; ++n2) {
            double d4 = this.w[n2];
            double d5 = this.QT.data[n3 + n2];
            int n6 = n2 * this.N;
            for (int i = n2; i < this.N; ++i) {
                int n7 = n6 + i;
                this.QT.data[n7] = this.QT.data[n7] + (d4 * this.QT.data[n3 + i] + this.w[i] * d5);
            }
        }
    }

    public void init(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Must be square");
        }
        if (denseMatrix64F.numCols != this.N) {
            this.N = denseMatrix64F.numCols;
            if (this.w.length < this.N) {
                this.w = new double[this.N];
                this.gammas = new double[this.N];
                this.b = new double[this.N];
            }
        }
        this.QT = denseMatrix64F;
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

