/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig.symm;

import org.ejml.alg.dense.decomposition.eig.symm.SymmetricQREigenHelper;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class SymmetricQrAlgorithm {
    private SymmetricQREigenHelper helper;
    private DenseMatrix64F Q;
    private double[] eigenvalues;
    private int exceptionalThresh = 15;
    private int maxIterations = this.exceptionalThresh * 15;
    private boolean fastEigenvalues;
    private boolean followingScript;

    public SymmetricQrAlgorithm(SymmetricQREigenHelper symmetricQREigenHelper) {
        this.helper = symmetricQREigenHelper;
    }

    public SymmetricQrAlgorithm() {
        this.helper = new SymmetricQREigenHelper();
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public DenseMatrix64F getQ() {
        return this.Q;
    }

    public void setQ(DenseMatrix64F denseMatrix64F) {
        this.Q = denseMatrix64F;
    }

    public void setFastEigenvalues(boolean bl) {
        this.fastEigenvalues = bl;
    }

    public double getEigenvalue(int n) {
        return this.helper.diag[n];
    }

    public int getNumberOfEigenvalues() {
        return this.helper.N;
    }

    public boolean process(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray != null) {
            this.helper.init(dArray, dArray2, n);
        }
        if (this.Q == null) {
            this.Q = CommonOps.identity(this.helper.N);
        }
        this.helper.setQ(this.Q);
        this.followingScript = true;
        this.eigenvalues = dArray3;
        this.fastEigenvalues = false;
        return this._process();
    }

    public boolean process(int n, double[] dArray, double[] dArray2) {
        if (dArray != null) {
            this.helper.init(dArray, dArray2, n);
        }
        this.followingScript = false;
        this.eigenvalues = null;
        return this._process();
    }

    private boolean _process() {
        while (this.helper.x2 >= 0) {
            if (this.helper.steps > this.maxIterations) {
                return false;
            }
            if (this.helper.x1 == this.helper.x2) {
                this.helper.resetSteps();
                if (!this.helper.nextSplit()) {
                    break;
                }
            } else if (this.fastEigenvalues && this.helper.x2 - this.helper.x1 == 1) {
                this.helper.resetSteps();
                this.helper.eigenvalue2by2(this.helper.x1);
                this.helper.setSubmatrix(this.helper.x2, this.helper.x2);
            } else if (this.helper.steps - this.helper.lastExceptional > this.exceptionalThresh) {
                this.helper.exceptionalShift();
            } else {
                this.performStep();
            }
            this.helper.incrementSteps();
        }
        return true;
    }

    public void performStep() {
        double d;
        for (int i = this.helper.x2 - 1; i >= this.helper.x1; --i) {
            if (!this.helper.isZero(i)) continue;
            this.helper.splits[this.helper.numSplits++] = i;
            this.helper.x1 = i + 1;
            return;
        }
        if (this.followingScript) {
            if (this.helper.steps > 10) {
                this.followingScript = false;
                return;
            }
            d = this.eigenvalues[this.helper.x2];
        } else {
            d = this.helper.computeShift();
        }
        this.helper.performImplicitSingleStep(d, false);
    }
}

