/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig;

import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.EigenDecomposition;
import org.ejml.ops.MatrixFeatures;

public class SwitchingEigenDecomposition
implements EigenDecomposition<DenseMatrix64F> {
    private double tol;
    EigenDecomposition<DenseMatrix64F> symmetricAlg;
    EigenDecomposition<DenseMatrix64F> generalAlg;
    boolean symmetric;
    boolean computeVectors;
    DenseMatrix64F A = new DenseMatrix64F(1, 1);

    public SwitchingEigenDecomposition(int n, boolean bl, double d) {
        this.symmetricAlg = DecompositionFactory.eig(n, bl, true);
        this.generalAlg = DecompositionFactory.eig(n, bl, false);
        this.computeVectors = bl;
        this.tol = d;
    }

    public SwitchingEigenDecomposition(int n) {
        this(n, true, 1.0E-8);
    }

    @Override
    public int getNumberOfEigenvalues() {
        return this.symmetric ? this.symmetricAlg.getNumberOfEigenvalues() : this.generalAlg.getNumberOfEigenvalues();
    }

    @Override
    public Complex64F getEigenvalue(int n) {
        return this.symmetric ? this.symmetricAlg.getEigenvalue(n) : this.generalAlg.getEigenvalue(n);
    }

    @Override
    public DenseMatrix64F getEigenVector(int n) {
        if (!this.computeVectors) {
            throw new IllegalArgumentException("Configured to not compute eignevectors");
        }
        return this.symmetric ? this.symmetricAlg.getEigenVector(n) : this.generalAlg.getEigenVector(n);
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.A.setReshape(denseMatrix64F);
        this.symmetric = MatrixFeatures.isSymmetric(this.A, this.tol);
        return this.symmetric ? this.symmetricAlg.decompose(this.A) : this.generalAlg.decompose(this.A);
    }

    @Override
    public boolean inputModified() {
        return false;
    }
}

