/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.alg.dense.decomposition.chol.CholeskyBlockHelper;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon;
import org.ejml.data.DenseMatrix64F;

public class CholeskyDecompositionBlock
extends CholeskyDecompositionCommon {
    private int blockWidth;
    private DenseMatrix64F B;
    private CholeskyBlockHelper chol;

    public CholeskyDecompositionBlock(int n) {
        super(true);
        this.blockWidth = n;
    }

    @Override
    public void setExpectedMaxSize(int n, int n2) {
        super.setExpectedMaxSize(n, n2);
        this.B = n < this.blockWidth ? new DenseMatrix64F(0, 0) : new DenseMatrix64F(this.blockWidth, this.maxWidth);
        this.chol = new CholeskyBlockHelper(this.blockWidth);
    }

    @Override
    protected boolean decomposeLower() {
        int n;
        int n2;
        if (this.n < this.blockWidth) {
            this.B.reshape(0, 0, false);
        } else {
            this.B.reshape(this.blockWidth, this.n - this.blockWidth, false);
        }
        int n3 = this.n / this.blockWidth;
        int n4 = this.n % this.blockWidth;
        if (n4 > 0) {
            ++n3;
        }
        this.B.numCols = this.n;
        for (n2 = 0; n2 < n3; ++n2) {
            this.B.numCols -= this.blockWidth;
            if (this.B.numCols > 0) {
                if (!this.chol.decompose(this.T, n2 * this.blockWidth * this.T.numCols + n2 * this.blockWidth, this.blockWidth)) {
                    return false;
                }
                n = n2 * this.blockWidth * this.T.numCols + (n2 + 1) * this.blockWidth;
                int n5 = (n2 + 1) * this.blockWidth * this.T.numCols + n2 * this.blockWidth;
                CholeskyDecompositionBlock.solveL_special(this.chol.getL().data, this.T, n, n5, this.B);
                int n6 = (n2 + 1) * this.blockWidth * this.n + (n2 + 1) * this.blockWidth;
                CholeskyDecompositionBlock.symmRankTranA_sub(this.B, this.T, n6);
                continue;
            }
            int n7 = n = n4 > 0 ? n4 : this.blockWidth;
            if (this.chol.decompose(this.T, n2 * this.blockWidth * this.T.numCols + n2 * this.blockWidth, n)) continue;
            return false;
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2 + 1; n < this.n; ++n) {
                this.t[n2 * this.n + n] = 0.0;
            }
        }
        return true;
    }

    @Override
    protected boolean decomposeUpper() {
        throw new RuntimeException("Not implemented.  Do a lower decomposition and transpose it...");
    }

    public static void solveL_special(double[] dArray, DenseMatrix64F denseMatrix64F, int n, int n2, DenseMatrix64F denseMatrix64F2) {
        double[] dArray2 = denseMatrix64F.data;
        double[] dArray3 = denseMatrix64F2.data;
        int n3 = denseMatrix64F2.numRows;
        int n4 = denseMatrix64F2.numCols;
        int n5 = n3;
        for (int i = 0; i < n4; ++i) {
            int n6 = i;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n5) {
                double d;
                double d2 = dArray2[n + n8 * denseMatrix64F.numCols + i];
                int n9 = n7;
                int n10 = n9 + n8;
                int n11 = i;
                while (n9 != n10) {
                    d2 -= dArray[n9++] * dArray3[n11];
                    n11 += n4;
                }
                dArray2[n2 + i * denseMatrix64F.numCols + n8] = d = d2 / dArray[n8 * n5 + n8];
                dArray3[n6] = d;
                ++n8;
                n6 += n4;
                n7 += n5;
            }
        }
    }

    public static void symmRankTranA_sub(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, int n) {
        double[] dArray = denseMatrix64F.data;
        double[] dArray2 = denseMatrix64F2.data;
        int n2 = denseMatrix64F2.numCols + 1;
        for (int i = 0; i < denseMatrix64F.numCols; ++i) {
            int n3 = i;
            int n4 = denseMatrix64F.numCols;
            int n5 = 0;
            while (n5 < denseMatrix64F.numRows) {
                int n6 = n;
                double d = dArray[n3];
                int n7 = n3;
                while (n7 < n4) {
                    int n8 = n6++;
                    dArray2[n8] = dArray2[n8] - d * dArray[n7++];
                }
                ++n5;
                n3 += denseMatrix64F.numCols;
                n4 += denseMatrix64F.numCols;
            }
            n += n2;
        }
    }
}

