/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.alg.block.BlockInnerTriangularSolver;
import org.ejml.alg.block.BlockMultiplication;
import org.ejml.data.D1Submatrix64F;

public class BlockTriangularSolver {
    public static void invert(int n, boolean bl, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, double[] dArray) {
        if (bl) {
            throw new IllegalArgumentException("Upper triangular matrices not supported yet");
        }
        if (dArray.length < n * n) {
            throw new IllegalArgumentException("Temp must be at least blockLength*blockLength long.");
        }
        if (d1Submatrix64F.row0 != d1Submatrix64F2.row0 || d1Submatrix64F.row1 != d1Submatrix64F2.row1 || d1Submatrix64F.col0 != d1Submatrix64F2.col0 || d1Submatrix64F.col1 != d1Submatrix64F2.col1) {
            throw new IllegalArgumentException("T and T_inv must be at the same elements in the matrix");
        }
        int n2 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        double[] dArray2 = d1Submatrix64F.original.data;
        double[] dArray3 = d1Submatrix64F2.original.data;
        int n3 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n2 * d1Submatrix64F.col0;
        for (int i = 0; i < n2; i += n) {
            int n4 = Math.min(d1Submatrix64F.row1 - (i + d1Submatrix64F.row0), n);
            int n5 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (i + d1Submatrix64F.col0);
            for (int j = 0; j < i; j += n) {
                int n6;
                int n7 = Math.min(d1Submatrix64F.col1 - (j + d1Submatrix64F.col0), n);
                for (n6 = 0; n6 < dArray.length; ++n6) {
                    dArray[n6] = 0.0;
                }
                for (n6 = j; n6 < i; n6 += n) {
                    int n8 = Math.min(d1Submatrix64F.col1 - (n6 + d1Submatrix64F.col0), n);
                    int n9 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (n6 + d1Submatrix64F.col0);
                    int n10 = n3 + d1Submatrix64F.original.numCols * (n6 + d1Submatrix64F.row0) + n8 * (j + d1Submatrix64F.col0);
                    BlockInnerMultiplication.blockMultMinus(dArray2, dArray3, dArray, n9, n10, 0, n4, n8, n7);
                }
                n6 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (j + d1Submatrix64F.col0);
                BlockInnerTriangularSolver.solveL(dArray2, dArray, n4, n7, n4, n5, 0);
                System.arraycopy(dArray, 0, dArray3, n6, n7 * n4);
            }
            BlockInnerTriangularSolver.invertLower(dArray2, dArray3, n4, n5, n5);
        }
    }

    public static void invert(int n, boolean bl, D1Submatrix64F d1Submatrix64F, double[] dArray) {
        if (bl) {
            throw new IllegalArgumentException("Upper triangular matrices not supported yet");
        }
        if (dArray.length < n * n) {
            throw new IllegalArgumentException("Temp must be at least blockLength*blockLength long.");
        }
        int n2 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        double[] dArray2 = d1Submatrix64F.original.data;
        int n3 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n2 * d1Submatrix64F.col0;
        for (int i = 0; i < n2; i += n) {
            int n4 = Math.min(d1Submatrix64F.row1 - (i + d1Submatrix64F.row0), n);
            int n5 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (i + d1Submatrix64F.col0);
            for (int j = 0; j < i; j += n) {
                int n6;
                int n7 = Math.min(d1Submatrix64F.col1 - (j + d1Submatrix64F.col0), n);
                for (n6 = 0; n6 < dArray.length; ++n6) {
                    dArray[n6] = 0.0;
                }
                for (n6 = j; n6 < i; n6 += n) {
                    int n8 = Math.min(d1Submatrix64F.col1 - (n6 + d1Submatrix64F.col0), n);
                    int n9 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (n6 + d1Submatrix64F.col0);
                    int n10 = n3 + d1Submatrix64F.original.numCols * (n6 + d1Submatrix64F.row0) + n8 * (j + d1Submatrix64F.col0);
                    BlockInnerMultiplication.blockMultMinus(dArray2, dArray2, dArray, n9, n10, 0, n4, n8, n7);
                }
                n6 = n3 + d1Submatrix64F.original.numCols * (i + d1Submatrix64F.row0) + n4 * (j + d1Submatrix64F.col0);
                BlockInnerTriangularSolver.solveL(dArray2, dArray, n4, n7, n4, n5, 0);
                System.arraycopy(dArray, 0, dArray2, n6, n7 * n4);
            }
            BlockInnerTriangularSolver.invertLower(dArray2, n4, n5);
        }
    }

    public static void solve(int n, boolean bl, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, boolean bl2) {
        if (bl) {
            BlockTriangularSolver.solveR(n, d1Submatrix64F, d1Submatrix64F2, bl2);
        } else {
            BlockTriangularSolver.solveL(n, d1Submatrix64F, d1Submatrix64F2, bl2);
        }
    }

    public static void solveBlock(int n, boolean bl, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, boolean bl2, boolean bl3) {
        int n2 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        if (n2 > n) {
            throw new IllegalArgumentException("T can be at most the size of a block");
        }
        int n3 = Math.min(n, d1Submatrix64F.original.numRows - d1Submatrix64F.row0);
        int n4 = Math.min(n, d1Submatrix64F.original.numCols - d1Submatrix64F.col0);
        int n5 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + n3 * d1Submatrix64F.col0;
        double[] dArray = d1Submatrix64F.original.data;
        double[] dArray2 = d1Submatrix64F2.original.data;
        if (bl3) {
            if (bl) {
                if (bl2) {
                    throw new IllegalArgumentException("Operation not yet supported");
                }
                throw new IllegalArgumentException("Operation not yet supported");
            }
            if (bl2) {
                throw new IllegalArgumentException("Operation not yet supported");
            }
            for (int i = d1Submatrix64F2.row0; i < d1Submatrix64F2.row1; i += n) {
                int n6 = Math.min(d1Submatrix64F2.row1, i + n) - i;
                int n7 = i * d1Submatrix64F2.original.numCols + n6 * d1Submatrix64F2.col0;
                BlockInnerTriangularSolver.solveLTransB(dArray, dArray2, n3, n6, n3, n5, n7);
            }
        } else {
            if (n2 != d1Submatrix64F2.row1 - d1Submatrix64F2.row0) {
                throw new IllegalArgumentException("T and B must have the same number of rows.");
            }
            if (bl) {
                if (bl2) {
                    for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                        int n8 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + n2 * i;
                        int n9 = Math.min(d1Submatrix64F2.col1, i + n) - i;
                        BlockInnerTriangularSolver.solveTransU(dArray, dArray2, n2, n9, n2, n5, n8);
                    }
                } else {
                    for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                        int n10 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + n2 * i;
                        int n11 = Math.min(d1Submatrix64F2.col1, i + n) - i;
                        BlockInnerTriangularSolver.solveU(dArray, dArray2, n2, n11, n2, n5, n10);
                    }
                }
            } else if (bl2) {
                for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                    int n12 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + n2 * i;
                    int n13 = Math.min(d1Submatrix64F2.col1, i + n) - i;
                    BlockInnerTriangularSolver.solveTransL(dArray, dArray2, n2, n13, n4, n5, n12);
                }
            } else {
                for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                    int n14 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + n2 * i;
                    int n15 = Math.min(d1Submatrix64F2.col1, i + n) - i;
                    BlockInnerTriangularSolver.solveL(dArray, dArray2, n2, n15, n4, n5, n14);
                }
            }
        }
    }

    public static void solveL(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, boolean bl) {
        int n2;
        int n3;
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(d1Submatrix64F2.original);
        D1Submatrix64F d1Submatrix64F4 = new D1Submatrix64F(d1Submatrix64F.original);
        D1Submatrix64F d1Submatrix64F5 = new D1Submatrix64F(d1Submatrix64F2.original);
        int n4 = d1Submatrix64F2.row1 - d1Submatrix64F2.row0;
        if (bl) {
            n3 = n4 - n4 % n;
            if (n3 == n4 && n4 >= n) {
                n3 -= n;
            }
            n2 = -n;
        } else {
            n3 = 0;
            n2 = n;
        }
        int n5 = n3;
        while (!(bl ? n5 < 0 : n5 >= n4)) {
            boolean bl2;
            int n6 = Math.min(n, n4 - n5);
            d1Submatrix64F4.col0 = d1Submatrix64F.col0 + n5;
            d1Submatrix64F4.col1 = d1Submatrix64F4.col0 + n6;
            d1Submatrix64F4.row0 = d1Submatrix64F.row0 + n5;
            d1Submatrix64F4.row1 = d1Submatrix64F4.row0 + n6;
            d1Submatrix64F5.col0 = d1Submatrix64F2.col0;
            d1Submatrix64F5.col1 = d1Submatrix64F2.col1;
            d1Submatrix64F5.row0 = d1Submatrix64F2.row0 + n5;
            d1Submatrix64F5.row1 = d1Submatrix64F5.row0 + n6;
            BlockTriangularSolver.solveBlock(n, false, d1Submatrix64F4, d1Submatrix64F5, bl, false);
            if (bl) {
                bl2 = d1Submatrix64F4.row0 > 0;
            } else {
                boolean bl3 = bl2 = d1Submatrix64F4.row1 < d1Submatrix64F.row1;
            }
            if (bl2) {
                if (bl) {
                    d1Submatrix64F4.col1 = d1Submatrix64F4.col0;
                    d1Submatrix64F4.col0 = d1Submatrix64F4.col1 - n;
                    d1Submatrix64F4.row1 = d1Submatrix64F.row1;
                    d1Submatrix64F5.row1 = d1Submatrix64F2.row1;
                    d1Submatrix64F3.row0 = d1Submatrix64F5.row0 - n;
                    d1Submatrix64F3.row1 = d1Submatrix64F5.row0;
                } else {
                    d1Submatrix64F4.row0 = d1Submatrix64F4.row1;
                    d1Submatrix64F4.row1 = Math.min(d1Submatrix64F4.row0 + n, d1Submatrix64F.row1);
                    d1Submatrix64F4.col0 = d1Submatrix64F.col0;
                    d1Submatrix64F5.row0 = d1Submatrix64F2.row0;
                    d1Submatrix64F3.row0 = d1Submatrix64F5.row1;
                    d1Submatrix64F3.row1 = Math.min(d1Submatrix64F3.row0 + n, d1Submatrix64F2.row1);
                }
                for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                    d1Submatrix64F5.col0 = i;
                    d1Submatrix64F5.col1 = Math.min(i + n, d1Submatrix64F2.col1);
                    d1Submatrix64F3.col0 = d1Submatrix64F5.col0;
                    d1Submatrix64F3.col1 = d1Submatrix64F5.col1;
                    if (bl) {
                        BlockMultiplication.multMinusTransA(n, d1Submatrix64F4, d1Submatrix64F5, d1Submatrix64F3);
                        continue;
                    }
                    BlockMultiplication.multMinus(n, d1Submatrix64F4, d1Submatrix64F5, d1Submatrix64F3);
                }
            }
            n5 += n2;
        }
    }

    public static void solveR(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, boolean bl) {
        int n2;
        int n3;
        int n4 = d1Submatrix64F2.row1 - d1Submatrix64F2.row0;
        if (d1Submatrix64F.getCols() != n4) {
            throw new IllegalArgumentException("Number of columns in R must be equal to the number of rows in B");
        }
        if (d1Submatrix64F.getRows() != n4) {
            throw new IllegalArgumentException("Number of rows in R must be equal to the number of rows in B");
        }
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(d1Submatrix64F2.original);
        D1Submatrix64F d1Submatrix64F4 = new D1Submatrix64F(d1Submatrix64F.original);
        D1Submatrix64F d1Submatrix64F5 = new D1Submatrix64F(d1Submatrix64F2.original);
        if (bl) {
            n3 = 0;
            n2 = n;
        } else {
            n3 = n4 - n4 % n;
            if (n3 == n4 && n4 >= n) {
                n3 -= n;
            }
            n2 = -n;
        }
        int n5 = n3;
        while (!(bl ? n5 >= n4 : n5 < 0)) {
            boolean bl2;
            int n6 = Math.min(n, n4 - n5);
            d1Submatrix64F4.col0 = d1Submatrix64F.col0 + n5;
            d1Submatrix64F4.col1 = d1Submatrix64F4.col0 + n6;
            d1Submatrix64F4.row0 = d1Submatrix64F.row0 + n5;
            d1Submatrix64F4.row1 = d1Submatrix64F4.row0 + n6;
            d1Submatrix64F5.col0 = d1Submatrix64F2.col0;
            d1Submatrix64F5.col1 = d1Submatrix64F2.col1;
            d1Submatrix64F5.row0 = d1Submatrix64F2.row0 + n5;
            d1Submatrix64F5.row1 = d1Submatrix64F5.row0 + n6;
            BlockTriangularSolver.solveBlock(n, true, d1Submatrix64F4, d1Submatrix64F5, bl, false);
            if (bl) {
                bl2 = d1Submatrix64F4.row1 < d1Submatrix64F.row1;
            } else {
                boolean bl3 = bl2 = d1Submatrix64F4.row0 > 0;
            }
            if (bl2) {
                if (bl) {
                    d1Submatrix64F4.col0 = d1Submatrix64F4.col1;
                    d1Submatrix64F4.col1 = Math.min(d1Submatrix64F4.col0 + n, d1Submatrix64F.col1);
                    d1Submatrix64F4.row0 = d1Submatrix64F.row0;
                    d1Submatrix64F5.row0 = d1Submatrix64F2.row0;
                    d1Submatrix64F3.row0 = d1Submatrix64F5.row1;
                    d1Submatrix64F3.row1 = Math.min(d1Submatrix64F3.row0 + n, d1Submatrix64F2.row1);
                } else {
                    d1Submatrix64F4.row1 = d1Submatrix64F4.row0;
                    d1Submatrix64F4.row0 = d1Submatrix64F4.row1 - n;
                    d1Submatrix64F4.col1 = d1Submatrix64F.col1;
                    d1Submatrix64F5.row1 = d1Submatrix64F2.row1;
                    d1Submatrix64F3.row0 = d1Submatrix64F5.row0 - n;
                    d1Submatrix64F3.row1 = d1Submatrix64F5.row0;
                }
                for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
                    d1Submatrix64F5.col0 = i;
                    d1Submatrix64F5.col1 = Math.min(i + n, d1Submatrix64F2.col1);
                    d1Submatrix64F3.col0 = d1Submatrix64F5.col0;
                    d1Submatrix64F3.col1 = d1Submatrix64F5.col1;
                    if (bl) {
                        BlockMultiplication.multMinusTransA(n, d1Submatrix64F4, d1Submatrix64F5, d1Submatrix64F3);
                        continue;
                    }
                    BlockMultiplication.multMinus(n, d1Submatrix64F4, d1Submatrix64F5, d1Submatrix64F3);
                }
            }
            n5 += n2;
        }
    }
}

