/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;

public class ArrayGenerator
extends Generator<Object> {
    private final Class<?> componentType;
    private final Generator<?> component;

    public ArrayGenerator(Class<?> componentType, Generator<?> component) {
        super(Object.class);
        this.componentType = componentType;
        this.component = component;
    }

    @Override
    public Object generate(SourceOfRandomness random, GenerationStatus status) {
        Object array = Array.newInstance(this.componentType, status.size());
        for (int i = 0; i < Array.getLength(array); ++i) {
            Array.set(array, i, this.component.generate(random, status));
        }
        return array;
    }

    @Override
    public void configure(Map<Class<? extends Annotation>, Annotation> configurationsByType) {
        this.component.configure(configurationsByType);
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        this.component.provideRepository(provided);
    }

    public Generator<?> componentGenerator() {
        return this.component;
    }
}

