package org.springframework.config.java.valuesource;

public class SystemPropertiesValueResolver extends AbstractStringBasedValueResolver {
    private static final String EXCEPTION_MSG_PREFIX = "System property has not been set: ";

    @Override
    public String getString(String name) throws ValueResolutionException {
    
        String value = System.getProperty(name);
        
        if(value == null)
            throw new ValueResolutionException(name, EXCEPTION_MSG_PREFIX);
        
        return value;
    }

}
