/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.aop;

import org.springframework.aop.config.AopConfigUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

/** TODO: JAVADOC */
/**
 * {@link BeanDefinitionParser} for the {@code aspectj-autoproxy} tag,
 * enabling the automatic application of @AspectJ-style aspects found in
 * the {@link org.springframework.beans.factory.BeanFactory}.
 *
 * @author Rob Harrop
 * @author Juergen Hoeller
 * @since 2.0
 */
class AspectJAutoProxyBeanDefinitionParser {

    public BeanDefinition parse(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry registry) {
        AopNamespaceUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(registry, dec);
        extendBeanDefinition(dec, registry);
        return null;
    }

    private void extendBeanDefinition(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry registry) {
        BeanDefinition beanDef =
                registry.getBeanDefinition(AopConfigUtils.AUTO_PROXY_CREATOR_BEAN_NAME);
        if (dec.getIncludePatterns().length > 0) {
            addIncludePatterns(dec, registry, beanDef);
        }
    }

    @SuppressWarnings("unchecked")
    private void addIncludePatterns(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry parserContext, BeanDefinition beanDef) {
        ManagedList includePatterns = new ManagedList();
        for (String pattern : dec.getIncludePatterns()) {
            TypedStringValue valueHolder = new TypedStringValue(pattern);
            includePatterns.add(valueHolder);
        }

        if (!includePatterns.isEmpty()) {
            //includePatterns.setSource(parserContext.extractSource(element));
            beanDef.getPropertyValues().addPropertyValue("includePatterns", includePatterns);
        }
    }

}
