/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.packagescanning;

import static test.common.util.Assert.assertBeanDefinitionCount;

import org.junit.Test;

import org.junit.runner.RunWith;

import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import org.springframework.config.java.context.ConfigurableJavaConfigApplicationContext;
import org.springframework.config.java.context.JavaConfigApplicationContext;

import java.util.ArrayList;
import java.util.Collection;


/** TODO: JAVADOC */
@RunWith(Parameterized.class)
public class BasePackageWildcardTests {
    private final String basePackage;

    private ConfigurableJavaConfigApplicationContext context;

    public BasePackageWildcardTests(String basePackage) { this.basePackage = basePackage; }

    @Parameters
    public static Collection<String[]> validWildcardValues() {
        ArrayList<String[]> values = new ArrayList<String[]>();
        values.add(new String[] { "test.feature.packagescanning.scanpkg.complex" });
        values.add(new String[] { "test/feature/packagescanning/scanpkg/complex" });
        values.add(new String[] { "test/feature/*/comp*" });
        return values;
    }

    @Test
    public void testConstructionWithWildcardBasePackage() {
        context = new JavaConfigApplicationContext(basePackage);

        assertBeanDefinitionCount(context, 2);
    }

}
