/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.callback;

import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;

import test.common.beans.TestBean;

/**
 * Proves that Configuration beans themselves are subject to lifecycle callbacks.
 *
 * @author Chris Beams
 */
public class ConfigurationBeanInitializationCallbackTests {

    @Configuration
    public static class Config implements InitializingBean, DisposableBean {
        boolean destroyCalled = false;
        boolean afterPropertiesSetCalled;

        public @Bean TestBean foo() { return new TestBean(); }

        public void afterPropertiesSet() throws Exception {
            afterPropertiesSetCalled = true;
        }

        public void destroy() throws Exception {
            destroyCalled = true;
        }

    }

    public @Test void testLifecycleCallbacks() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(Config.class);
        Config config = ctx.getBean(Config.class);
        ctx.close();

        assertTrue(config.afterPropertiesSetCalled);
        assertTrue(config.destroyCalled);
    }

}
