/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.bpp;

import org.junit.Test;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;


/**
 * SJC-17 demonstrates the fact that JavaConfig's approach to programmatic bean creation is
 * fundamentally incompatible with RequiredAnnotationBeanPostProcessor. SJC-91 addresses this issue
 * by creating a new strategy for checking {@link Required @Required} properties.
 *
 * <p>This test simply proves the incompatibility.</p>
 *
 * @see     Sjc91Tests
 * @author  Chris Beams
 */
public class Sjc17Tests {
    @Test(expected = BeanCreationException.class)
    public void proveIncompatibility() { new JavaConfigApplicationContext(ApplicationConfiguration.class); }
}

@Configuration
class ApplicationConfiguration {
    @Bean
    public XYZ xyz() { return new XYZ(); }

    @Bean
    public RequiredAnnotationBeanPostProcessor bpp() { return new RequiredAnnotationBeanPostProcessor(); }
}

class XYZ {
    @SuppressWarnings("unused")
    private int i;

    @Required
    public void setFoo(int i) { this.i = i; }
}
