/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.aop;

import static org.junit.Assert.*;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.junit.Test;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.plugin.aop.AspectJAutoProxy;

import test.common.beans.TestBean;


/**
 * System tests related to applying {@code @Aspect}s.
 *
 * @author  Chris Beams
 */
public class AspectIntegrationTests {

    @Test
    public void configClassesCanPlayDoubleDutyAsAspectClasses() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(AspectConfig.class);
        AspectConfig config = ctx.getBean(AspectConfig.class);
        assertFalse(config.beforeAdviceExecuted);
        TestBean alice = ctx.getBean(TestBean.class);
        TestBean alice2 = ctx.getBean(TestBean.class);
        assertSame(alice, alice2);
        alice.getName();
        assertTrue(config.beforeAdviceExecuted);
    }

    @Configuration
    static class SomeConfig {
        @Bean
        public TestBean alice() { return new TestBean(); }
    }

    @Aspect
    static class SomeAspect {
        boolean beforeAdviceExecuted = false;

        @Before("execution(* getName())")
        public void flipBit() { beforeAdviceExecuted = true; }
    }

    @AspectJAutoProxy(proxyTargetClass=true)
    @Aspect
    @Configuration
    static class AspectConfig {

        boolean beforeAdviceExecuted = false;

        @Bean
        public TestBean alice() { return new TestBean(); }

        @Before("execution(* getName())")
        public void flipBit() { beforeAdviceExecuted = true; }
    }
}
