/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.parsing.asm;

import static org.junit.Assert.assertEquals;
import static org.springframework.util.ClassUtils.convertClassNameToResourcePath;

import java.io.IOException;

import org.junit.Test;
import org.springframework.asm.ClassReader;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.parsing.ConfigurationParser;
import org.springframework.config.java.model.ModelMethod;


/**
 * TODO: JAVADOC
 * 
 * NOTE: These tests may break easily based on formatting changes in the classes
 * being read. i.e.: if the line numbers change, these tests will have to be
 * updated to reflect.
 * 
 * @author Chris Beams
 */
public class AsmConfigurationParserSourceTrackingTests {

    public @Test void simpleSourceTracking() throws IOException {
        ConfigurationModel model = new ConfigurationModel();
        ConfigurationParser parser = new AsmConfigurationParser(model);
        parser.parse(new ClassReader(LineNumberConfig.class.getName()));

        String expectedResourcePath =
            convertClassNameToResourcePath(LineNumberConfig.class.getName()).concat(".java");

        ConfigurationClass config = model.getAllConfigurationClasses()[0];
        assertEquals(expectedResourcePath, config.getSource());

        ModelMethod fooMethod = config.getMethod("foo");
        assertEquals(31, fooMethod.getLineNumber());

        ModelMethod barMethod = config.getMethod("bar");
        assertEquals(35, barMethod.getLineNumber());

        ModelMethod nonSjcMethod = config.getMethod("nonJavaConfigMethod");
        assertEquals(39, nonSjcMethod.getLineNumber());
    }

    public @Test void sourceTrackingWithNestedConfigurationClass() throws IOException {
        ConfigurationModel model = new ConfigurationModel();
        ConfigurationParser parser = new AsmConfigurationParser(model);
        parser.parse(new ClassReader(NestedLineNumberConfig.NestedConfig.class.getName()));

        String expectedResourcePath =
            convertClassNameToResourcePath(NestedLineNumberConfig.class.getName()).concat(".java");

        ConfigurationClass config = model.getAllConfigurationClasses()[0];
        assertEquals(expectedResourcePath, config.getSource());

        ModelMethod fooMethod = config.getMethod("foo");
        assertEquals(30, fooMethod.getLineNumber());
    }

}
