/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.test;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigContextLoader
implements ContextLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public String[] processLocations(Class<?> clazz, String ... locations) {
        return locations;
    }

    public ApplicationContext loadContext(String ... locations) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating a JavaConfigApplicationContext for " + Arrays.asList(locations)));
        }
        JavaConfigApplicationContext context = new JavaConfigApplicationContext();
        ArrayList configClasses = new ArrayList();
        ArrayList<String> basePackages = new ArrayList<String>();
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                Class<?> aClass = this.getClass().getClassLoader().loadClass(string);
                configClasses.add(aClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Package.getPackage(string) == null) {
                    throw new IllegalArgumentException(String.format("A non-existent class or package name was specified: [%s]", string));
                }
                basePackages.add(string);
            }
            ++n2;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting config classes to " + configClasses));
            this.logger.debug((Object)("Setting base packages to " + basePackages));
        }
        for (Class clazz : configClasses) {
            context.addConfigClass(clazz);
        }
        for (String string : basePackages) {
            context.addBasePackage(string);
        }
        context.refresh();
        GenericApplicationContext genericApplicationContext = new GenericApplicationContext((ApplicationContext)context);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)genericApplicationContext);
        genericApplicationContext.refresh();
        genericApplicationContext.registerShutdownHook();
        return genericApplicationContext;
    }
}

