/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.util.List;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.internal.model.UsageError;
import org.springframework.config.java.internal.model.ValidatableMethod;
import org.springframework.config.java.model.ModelMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonJavaConfigMethod
extends ModelMethod
implements ValidatableMethod {
    public NonJavaConfigMethod(String name, int modifiers, Annotation ... annotations) {
        super(name, modifiers, annotations);
    }

    NonJavaConfigMethod(String name) {
        this(name, 0, new Annotation[0]);
    }

    @Override
    public void detectUsageErrors(List<UsageError> errors) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            errors.add(new InvalidAnnotationDeclarationError(anno));
            ++n2;
        }
    }

    public class InvalidAnnotationDeclarationError
    extends UsageError {
        private final Annotation invalidAnno;

        public InvalidAnnotationDeclarationError(Annotation invalidAnno) {
            super(NonJavaConfigMethod.this.getDeclaringClass(), NonJavaConfigMethod.this.getLineNumber());
            this.invalidAnno = invalidAnno;
        }

        public String getDescription() {
            return String.format("Illegal placement of @%s annotation on method %s. Perhaps you meant for this method to be a @%s method? Remove the offending annotation or fix the declaration so it is compliant.", this.invalidAnno.annotationType().getSimpleName(), NonJavaConfigMethod.this.getName(), Bean.class.getSimpleName());
        }
    }
}

