/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import org.springframework.config.java.internal.model.UsageError;
import org.springframework.config.java.model.ModelMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaConfigMethod
extends ModelMethod {
    public JavaConfigMethod(String name, int modifiers, Annotation[] annotations) {
        super(name, modifiers, annotations);
    }

    public abstract Annotation getMetadata();

    public void detectUsageErrors(List<UsageError> errors) {
        if (Modifier.isPrivate(this.getModifiers())) {
            errors.add(new PrivateMethodError());
        }
        if (Modifier.isFinal(this.getModifiers())) {
            errors.add(new FinalMethodError());
        }
    }

    public class FinalMethodError
    extends UsageError {
        public FinalMethodError() {
            super(JavaConfigMethod.this.getDeclaringClass(), JavaConfigMethod.this.getLineNumber());
        }

        public String getDescription() {
            return String.format("@%s method '%s' may not be final. Remove the final modifier to continue.", JavaConfigMethod.this.getMetadata().annotationType().getSimpleName(), JavaConfigMethod.this.getName());
        }
    }

    public class IncompatibleAnnotationError
    extends UsageError {
        private final Annotation incompatibleAnno;

        public IncompatibleAnnotationError(Annotation incompatibleAnno) {
            super(JavaConfigMethod.this.getDeclaringClass(), JavaConfigMethod.this.getLineNumber());
            this.incompatibleAnno = incompatibleAnno;
        }

        public String getDescription() {
            String incompatibleAnnoName = this.incompatibleAnno.annotationType().getSimpleName();
            return String.format("@%s method '%s' is not compatible with @%s annotation. Remove the @%s annotation to continue.", JavaConfigMethod.this.getMetadata().annotationType().getSimpleName(), JavaConfigMethod.this.getName(), incompatibleAnnoName, incompatibleAnnoName);
        }
    }

    public class PrivateMethodError
    extends UsageError {
        public PrivateMethodError() {
            super(JavaConfigMethod.this.getDeclaringClass(), JavaConfigMethod.this.getLineNumber());
        }

        public String getDescription() {
            return String.format("@%s method '%s' may not be private. If bean hiding is desired, consider making this method protected or package-private", JavaConfigMethod.this.getMetadata().annotationType().getSimpleName(), JavaConfigMethod.this.getName());
        }
    }
}

