/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.enhancement;

import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassAdapter;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;

class AddAnnotationAdapter
extends ClassAdapter {
    private String annotationDesc;
    private boolean isAnnotationPresent;

    public AddAnnotationAdapter(ClassVisitor cv, String annotationDesc) {
        super(cv);
        this.annotationDesc = annotationDesc;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int v = (version & 0xFF) < 49 ? 49 : version;
        this.cv.visit(v, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible && desc.equals(this.annotationDesc)) {
            this.isAnnotationPresent = true;
        }
        return this.cv.visitAnnotation(desc, visible);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.addAnnotation();
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.addAnnotation();
        return this.cv.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.addAnnotation();
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        this.addAnnotation();
        this.cv.visitEnd();
    }

    private void addAnnotation() {
        if (!this.isAnnotationPresent) {
            AnnotationVisitor av = this.cv.visitAnnotation(this.annotationDesc, true);
            if (av != null) {
                av.visitEnd();
            }
            this.isAnnotationPresent = true;
        }
    }
}

