/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    public static final TypeDescriptor NULL = new TypeDescriptor();
    private static final TypeDescriptor UNKNOWN = new TypeDescriptor(Object.class);
    private static final Map<Class<?>, TypeDescriptor> typeDescriptorCache = new HashMap();
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private Class<?> type;
    private MethodParameter methodParameter;
    private Field field;
    private int fieldNestingLevel = 1;
    private Object value;
    private volatile TypeDescriptor elementType;
    private volatile TypeDescriptor mapKeyType;
    private volatile TypeDescriptor mapValueType;
    private volatile Annotation[] annotations;

    static {
        typeDescriptorCache.put(Boolean.TYPE, new TypeDescriptor(Boolean.TYPE));
        typeDescriptorCache.put(Boolean.class, new TypeDescriptor(Boolean.class));
        typeDescriptorCache.put(Byte.TYPE, new TypeDescriptor(Byte.TYPE));
        typeDescriptorCache.put(Byte.class, new TypeDescriptor(Byte.class));
        typeDescriptorCache.put(Character.TYPE, new TypeDescriptor(Character.TYPE));
        typeDescriptorCache.put(Character.class, new TypeDescriptor(Character.class));
        typeDescriptorCache.put(Short.TYPE, new TypeDescriptor(Short.TYPE));
        typeDescriptorCache.put(Short.class, new TypeDescriptor(Short.class));
        typeDescriptorCache.put(Integer.TYPE, new TypeDescriptor(Integer.TYPE));
        typeDescriptorCache.put(Integer.class, new TypeDescriptor(Integer.class));
        typeDescriptorCache.put(Long.TYPE, new TypeDescriptor(Long.TYPE));
        typeDescriptorCache.put(Long.class, new TypeDescriptor(Long.class));
        typeDescriptorCache.put(Float.TYPE, new TypeDescriptor(Float.TYPE));
        typeDescriptorCache.put(Float.class, new TypeDescriptor(Float.class));
        typeDescriptorCache.put(Double.TYPE, new TypeDescriptor(Double.TYPE));
        typeDescriptorCache.put(Double.class, new TypeDescriptor(Double.class));
        typeDescriptorCache.put(String.class, new TypeDescriptor(String.class));
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
    }

    public TypeDescriptor(MethodParameter methodParameter, Class<?> type) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.type = type;
    }

    public TypeDescriptor(Field field, Class<?> type) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.type = type;
    }

    private TypeDescriptor(Field field, int nestingLevel, Class<?> type) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.fieldNestingLevel = nestingLevel;
        this.type = type;
    }

    private TypeDescriptor() {
    }

    private TypeDescriptor(Object value) {
        Assert.notNull(value, "Value must not be null");
        this.value = value;
        this.type = value.getClass();
    }

    private TypeDescriptor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        this.type = type;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getParameterType();
        }
        return null;
    }

    public Class<?> getObjectType() {
        Class<?> type = this.getType();
        return type != null ? ClassUtils.resolvePrimitiveIfNecessary(type) : type;
    }

    public String getName() {
        Class<?> type = this.getType();
        return type != null ? ClassUtils.getQualifiedName(type) : null;
    }

    public boolean isPrimitive() {
        Class<?> type = this.getType();
        return type != null && type.isPrimitive();
    }

    public boolean isArray() {
        Class<?> type = this.getType();
        return type != null && type.isArray();
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public Class<?> getElementType() {
        return this.getElementTypeDescriptor().getType();
    }

    public TypeDescriptor getElementTypeDescriptor() {
        if (this.elementType == null) {
            this.elementType = this.forElementType(this.resolveElementType());
        }
        return this.elementType;
    }

    public TypeDescriptor getElementTypeDescriptor(Object element) {
        TypeDescriptor elementType = this.getElementTypeDescriptor();
        return !UNKNOWN.equals(elementType) ? elementType : TypeDescriptor.forObject(element);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public boolean isMapEntryTypeKnown() {
        return this.isMap() && this.getMapKeyType() != null && this.getMapValueType() != null;
    }

    public Class<?> getMapKeyType() {
        return this.getMapKeyTypeDescriptor().getType();
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        if (this.mapKeyType == null) {
            this.mapKeyType = this.forElementType(this.resolveMapKeyType());
        }
        return this.mapKeyType;
    }

    public TypeDescriptor getMapKeyTypeDescriptor(Object key) {
        TypeDescriptor keyType = this.getMapKeyTypeDescriptor();
        return !UNKNOWN.equals(keyType) ? keyType : TypeDescriptor.forObject(key);
    }

    public Class<?> getMapValueType() {
        return this.getMapValueTypeDescriptor().getType();
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        if (this.mapValueType == null) {
            this.mapValueType = this.forElementType(this.resolveMapValueType());
        }
        return this.mapValueType;
    }

    public TypeDescriptor getMapValueTypeDescriptor(Object value) {
        TypeDescriptor valueType = this.getMapValueTypeDescriptor();
        return !UNKNOWN.equals(valueType) ? valueType : TypeDescriptor.forObject(value);
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAssignableTo(TypeDescriptor targetType) {
        if (this == NULL || targetType == NULL) {
            return true;
        }
        if (this.isCollection() && targetType.isCollection() || this.isArray() && targetType.isArray()) {
            return targetType.getType().isAssignableFrom(this.getType()) && this.getElementTypeDescriptor().isAssignableTo(targetType.getElementTypeDescriptor());
        }
        if (this.isMap() && targetType.isMap()) {
            return targetType.getType().isAssignableFrom(this.getType()) && this.getMapKeyTypeDescriptor().isAssignableTo(targetType.getMapKeyTypeDescriptor()) && this.getMapValueTypeDescriptor().isAssignableTo(targetType.getMapValueTypeDescriptor());
        }
        return targetType.getObjectType().isAssignableFrom(this.getObjectType());
    }

    public TypeDescriptor forElementType(Class<?> elementType) {
        if (elementType == null) {
            return UNKNOWN;
        }
        if (this.methodParameter != null) {
            MethodParameter nested = new MethodParameter(this.methodParameter);
            nested.increaseNestingLevel();
            return new TypeDescriptor(nested, elementType);
        }
        if (this.field != null) {
            return new TypeDescriptor(this.field, this.fieldNestingLevel + 1, elementType);
        }
        return TypeDescriptor.valueOf(elementType);
    }

    public boolean equals(Object obj) {
        boolean annotatedTypeEquals;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeDescriptor) || obj == NULL) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        boolean bl = annotatedTypeEquals = this.getType().equals(other.getType()) && ObjectUtils.nullSafeEquals(this.getAnnotations(), other.getAnnotations());
        if (this.isCollection()) {
            return annotatedTypeEquals && ObjectUtils.nullSafeEquals(this.getElementType(), other.getElementType());
        }
        if (this.isMap()) {
            return annotatedTypeEquals && ObjectUtils.nullSafeEquals(this.getMapKeyType(), other.getMapKeyType()) && ObjectUtils.nullSafeEquals(this.getMapValueType(), other.getMapValueType());
        }
        return annotatedTypeEquals;
    }

    public int hashCode() {
        return this == NULL ? 0 : this.getType().hashCode();
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        Annotation[] anns;
        if (this == NULL) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        Annotation[] annotationArray = anns = this.getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            builder.append("@").append(ann.annotationType().getName()).append(' ');
            ++n2;
        }
        builder.append(ClassUtils.getQualifiedName(this.getType()));
        if (this.isMap()) {
            builder.append("<").append(this.getMapKeyTypeDescriptor());
            builder.append(", ").append(this.getMapValueTypeDescriptor()).append(">");
        } else if (this.isCollection()) {
            builder.append("<").append(this.getElementTypeDescriptor()).append(">");
        }
        return builder.toString();
    }

    private Class<?> resolveElementType() {
        if (this.isArray()) {
            return this.getType().getComponentType();
        }
        if (this.isCollection()) {
            return this.resolveCollectionElementType();
        }
        return null;
    }

    private Class<?> resolveCollectionElementType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getCollectionFieldType(this.field, this.fieldNestingLevel);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
        }
        if (this.value instanceof Collection) {
            Class<?> elementType = CollectionUtils.findCommonElementType((Collection)this.value);
            if (elementType != null) {
                return elementType;
            }
        } else if (this.type != null) {
            return GenericCollectionTypeResolver.getCollectionType(this.type);
        }
        return null;
    }

    private Class<?> resolveMapKeyType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapKeyFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
        }
        if (this.value instanceof Map) {
            Class<?> keyType = CollectionUtils.findCommonElementType(((Map)this.value).keySet());
            if (keyType != null) {
                return keyType;
            }
        } else if (this.type != null && this.isMap()) {
            return GenericCollectionTypeResolver.getMapKeyType(this.type);
        }
        return null;
    }

    private Class<?> resolveMapValueType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapValueFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
        }
        if (this.value instanceof Map) {
            Class<?> valueType = CollectionUtils.findCommonElementType(((Map)this.value).values());
            if (valueType != null) {
                return valueType;
            }
        } else if (this.type != null && this.isMap()) {
            return GenericCollectionTypeResolver.getMapValueType(this.type);
        }
        return null;
    }

    private Annotation[] resolveAnnotations() {
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        if (this.methodParameter != null) {
            if (this.methodParameter.getParameterIndex() < 0) {
                return this.methodParameter.getMethodAnnotations();
            }
            return this.methodParameter.getParameterAnnotations();
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    public static TypeDescriptor forObject(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof Collection || object instanceof Map) {
            return new TypeDescriptor(object);
        }
        return TypeDescriptor.valueOf(object.getClass());
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        if (type == null) {
            return NULL;
        }
        TypeDescriptor desc = typeDescriptorCache.get(type);
        return desc != null ? desc : new TypeDescriptor(type);
    }
}

